/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.aggregate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.core.BucketRange;
import org.nuxeo.elasticsearch.aggregate.MultiBucketAggregate;

public class HistogramAggregate
extends MultiBucketAggregate<BucketRange> {
    private Integer interval;

    public HistogramAggregate(AggregateDefinition definition, DocumentModel searchDocument) {
        super(definition, searchDocument);
    }

    @JsonIgnore
    public HistogramAggregationBuilder getEsAggregate() {
        HistogramAggregationBuilder ret = (HistogramAggregationBuilder)AggregationBuilders.histogram((String)this.getId()).field(this.getField());
        Map props = this.getProperties();
        ret.interval((double)this.getInterval());
        if (props.containsKey("minDocCount")) {
            ret.minDocCount(Long.parseLong((String)props.get("minDocCount")));
        }
        if (props.containsKey("order")) {
            switch (((String)props.get("order")).toLowerCase()) {
                case "count desc": {
                    ret.order(BucketOrder.count((boolean)false));
                    break;
                }
                case "count asc": {
                    ret.order(BucketOrder.count((boolean)true));
                    break;
                }
                case "key desc": {
                    ret.order(BucketOrder.key((boolean)false));
                    break;
                }
                case "key asc": {
                    ret.order(BucketOrder.key((boolean)true));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid order: " + (String)props.get("order"));
                }
            }
        }
        if (props.containsKey("extendedBoundsMax") && props.containsKey("extendedBoundsMin")) {
            ret.extendedBounds((double)Long.parseLong((String)props.get("extendedBoundsMin")), (double)Long.parseLong((String)props.get("extendedBoundsMax")));
        }
        return ret;
    }

    @Override
    @JsonIgnore
    public QueryBuilder getEsFilter() {
        if (this.getSelection().isEmpty()) {
            return null;
        }
        BoolQueryBuilder ret = QueryBuilders.boolQuery();
        for (String sel : this.getSelection()) {
            RangeQueryBuilder rangeFilter = QueryBuilders.rangeQuery((String)this.getField());
            long from = Float.valueOf(sel).longValue();
            long to = from + (long)this.getInterval();
            rangeFilter.gte((Object)from).lt((Object)to);
            ret.should((QueryBuilder)rangeFilter);
        }
        return ret;
    }

    @Override
    @JsonIgnore
    public void parseEsBuckets(Collection<? extends MultiBucketsAggregation.Bucket> buckets) {
        ArrayList<BucketRange> nxBuckets = new ArrayList<BucketRange>(buckets.size());
        for (MultiBucketsAggregation.Bucket bucket : buckets) {
            Histogram.Bucket histoBucket = (Histogram.Bucket)bucket;
            int from = this.parseInt(histoBucket.getKeyAsString());
            nxBuckets.add(new BucketRange(bucket.getKeyAsString(), (Number)from, (Number)(from + this.getInterval()), histoBucket.getDocCount()));
        }
        this.buckets = nxBuckets;
    }

    public int getInterval() {
        if (this.interval == null) {
            Map props = this.getProperties();
            if (props.containsKey("interval")) {
                this.interval = Integer.parseInt((String)props.get("interval"));
            } else {
                throw new IllegalArgumentException("interval property must be defined for " + this.toString());
            }
        }
        return this.interval;
    }

    protected int parseInt(String key) {
        if ("-Infinity".equals(key)) {
            return Integer.MIN_VALUE;
        }
        if ("+Infinity".equals(key)) {
            return Integer.MAX_VALUE;
        }
        return Math.round(Float.parseFloat(key));
    }
}

