/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.work;

import java.io.Serializable;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.work.AbstractIndexingWorker;
import org.nuxeo.runtime.api.Framework;

public class ChildrenIndexingWorker
extends AbstractIndexingWorker
implements Work {
    private static final long serialVersionUID = 724369727479693496L;

    public ChildrenIndexingWorker(IndexingCommand cmd) {
        super(cmd);
    }

    public String getTitle() {
        return " ElasticSearch indexing children for cmd " + (Serializable)(this.cmds.isEmpty() ? "null" : (Serializable)this.cmds.get(0));
    }

    @Override
    protected void doIndexingWork(ElasticSearchIndexing esi, List<IndexingCommand> cmds) {
        if (cmds.isEmpty()) {
            return;
        }
        IndexingCommand cmd = cmds.get(0);
        DocumentModel doc = this.getDocument(cmd);
        if (doc == null) {
            return;
        }
        DocumentModelIterator iter = this.session.getChildrenIterator(doc.getRef());
        while (iter.hasNext()) {
            this.session.save();
            DocumentModel child = (DocumentModel)iter.next();
            IndexingCommand childCommand = cmd.clone(child);
            esi.indexNonRecursive(childCommand);
            if (!child.isFolder()) continue;
            ChildrenIndexingWorker subWorker = new ChildrenIndexingWorker(childCommand);
            WorkManager wm = (WorkManager)Framework.getService(WorkManager.class);
            wm.schedule((Work)subWorker);
        }
    }

    private DocumentModel getDocument(IndexingCommand cmd) {
        DocumentModel doc = cmd.getTargetDocument();
        if (doc == null) {
            return null;
        }
        return doc;
    }
}

