/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class RemovedCollectionListener
implements EventListener {
    private static final Log log = LogFactory.getLog(RemovedCollectionListener.class);

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentModel doc = ((DocumentEventContext)ctx).getSourceDocument();
        CollectionManager collectionManager = (CollectionManager)Framework.getService(CollectionManager.class);
        boolean isCollectionRemoved = collectionManager.isCollection(doc);
        boolean isCollectionMemberRemoved = collectionManager.isCollected(doc);
        if (isCollectionRemoved) {
            log.trace((Object)String.format("Collection %s removed", doc.getId()));
            collectionManager.processRemovedCollection(doc);
        } else if (isCollectionMemberRemoved) {
            log.trace((Object)String.format("CollectionMember %s removed", doc.getId()));
            collectionManager.processRemovedCollectionMember(doc);
        }
    }
}

