/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingKey;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import java.util.HashMap;
import java.util.Map;

public abstract class AggregatorBase
implements Aggregator {
    private Map<BindingKey, Accumulator> buckets = new HashMap<BindingKey, Accumulator>();
    protected static final int HC_AggAvg = 368;
    protected static final int HC_AggAvgDistinct = 369;
    protected static final int HC_AggCount = 370;
    protected static final int HC_AggCountDistinct = 371;
    protected static final int HC_AggCountVar = 372;
    protected static final int HC_AggCountVarDistinct = 373;
    protected static final int HC_AggMin = 374;
    protected static final int HC_AggMinDistinct = 375;
    protected static final int HC_AggMax = 376;
    protected static final int HC_AggMaxDistinct = 377;
    protected static final int HC_AggSample = 378;
    protected static final int HC_AggSampleDistinct = 379;
    protected static final int HC_AggSum = 380;
    protected static final int HC_AggSumDistinct = 381;
    protected static final int HC_AggGroupConcat = 382;
    protected static final int HC_AggGroupConcatDistinct = 383;

    protected AggregatorBase() {
    }

    public final void accumulate(BindingKey key, Binding binding, FunctionEnv functionEnv) {
        Accumulator acc = this.buckets.get(key);
        if (acc == null) {
            acc = this.createAccumulator();
            this.buckets.put(key, acc);
        }
        acc.accumulate(binding, functionEnv);
    }

    protected abstract Accumulator createAccumulator();

    public abstract Node getValueEmpty();

    public Node getValue(BindingKey key) {
        Accumulator acc = this.buckets.get(key);
        if (acc == null) {
            throw new ARQInternalErrorException("Null for accumulator");
        }
        NodeValue nv = acc.getValue();
        if (nv == null) {
            return null;
        }
        return nv.asNode();
    }

    public String key() {
        return this.toPrefixString();
    }

    public final Aggregator copyTransform(NodeTransform transform) {
        Expr e2 = this.getExpr();
        if (e2 != null) {
            e2 = e2.applyNodeTransform(transform);
        }
        return this.copy(e2);
    }

    public abstract String toString();

    public abstract String toPrefixString();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

