/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.path;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.path.P_Alt;
import com.hp.hpl.jena.sparql.path.P_FixedLength;
import com.hp.hpl.jena.sparql.path.P_Inverse;
import com.hp.hpl.jena.sparql.path.P_Link;
import com.hp.hpl.jena.sparql.path.P_Mod;
import com.hp.hpl.jena.sparql.path.P_NegPropSet;
import com.hp.hpl.jena.sparql.path.P_OneOrMore;
import com.hp.hpl.jena.sparql.path.P_Path0;
import com.hp.hpl.jena.sparql.path.P_Path2;
import com.hp.hpl.jena.sparql.path.P_ReverseLink;
import com.hp.hpl.jena.sparql.path.P_Seq;
import com.hp.hpl.jena.sparql.path.P_ZeroOrMore;
import com.hp.hpl.jena.sparql.path.P_ZeroOrOne;
import com.hp.hpl.jena.sparql.path.Path;
import com.hp.hpl.jena.sparql.path.PathVisitor;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import java.util.List;
import org.openjena.atlas.io.IndentedLineBuffer;
import org.openjena.atlas.io.IndentedWriter;

public class PathWriter {
    public static void write(Path path, Prologue prologue) {
        PathWriter.write(IndentedWriter.stdout, path, prologue);
    }

    public static void write(IndentedWriter out, Path path, Prologue prologue) {
        PathWriterWorker w = new PathWriterWorker(out, prologue);
        path.visit(w);
        out.flush();
    }

    public static String asString(Path path) {
        return PathWriter.asString(path, null);
    }

    public static String asString(Path path, Prologue prologue) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        PathWriterWorker w = new PathWriterWorker(buff, prologue);
        path.visit(w);
        w.out.flush();
        return buff.asString();
    }

    static class PathWriterWorker
    implements PathVisitor {
        private IndentedWriter out;
        private Prologue prologue;
        private static boolean alwaysInnerParens = true;
        private boolean needParens = false;

        PathWriterWorker(IndentedWriter indentedWriter, Prologue prologue) {
            this.out = indentedWriter;
            this.prologue = prologue;
        }

        private void visitPath(Path path) {
            this.visitPath(path, true);
        }

        private void visitPath(Path path, boolean needParensThisTime) {
            if (alwaysInnerParens) {
                needParensThisTime = true;
            }
            boolean b = this.needParens;
            this.needParens = needParensThisTime;
            path.visit(this);
            this.needParens = b;
        }

        private void output(Node node) {
            this.out.print(FmtUtils.stringForNode(node, this.prologue));
        }

        private void output(P_Path0 path0) {
            if (!path0.isForward()) {
                this.out.print("^");
            }
            this.out.print(FmtUtils.stringForNode(path0.getNode(), this.prologue));
        }

        public void visit(P_Link pathNode) {
            this.output(pathNode.getNode());
        }

        public void visit(P_ReverseLink pathNode) {
            this.out.println("^");
            this.output(pathNode.getNode());
        }

        public void visit(P_NegPropSet pathNotOneOf) {
            List<P_Path0> props = pathNotOneOf.getNodes();
            if (props.size() == 0) {
                throw new ARQException("Bad path element: NotOneOf found with no elements");
            }
            this.out.print("!");
            if (props.size() == 1) {
                this.output(props.get(0));
            } else {
                this.out.print("(");
                boolean first = true;
                for (P_Path0 p : props) {
                    if (!first) {
                        this.out.print("|");
                    }
                    first = false;
                    this.output(p);
                }
                this.out.print(")");
            }
        }

        public void visit(P_Alt pathAlt) {
            this.visit2(pathAlt, "|", true);
        }

        public void visit(P_Seq pathSeq) {
            this.visit2(pathSeq, "/", false);
        }

        private void visit2(P_Path2 path2, String sep, boolean isSeq) {
            if (this.needParens) {
                this.out.print("(");
            }
            this.visitPath(path2.getLeft());
            this.out.print(sep);
            if (isSeq) {
                if (path2.getRight() instanceof P_Seq) {
                    this.visitPath(path2.getRight(), this.needParens);
                } else {
                    this.visitPath(path2.getRight(), true);
                }
            } else {
                this.visitPath(path2.getRight(), true);
            }
            if (this.needParens) {
                this.out.print(")");
            }
        }

        public void visit(P_Mod pathMod) {
            if (this.needParens) {
                this.out.print("(");
            }
            if (alwaysInnerParens) {
                this.out.print("(");
            }
            pathMod.getSubPath().visit(this);
            if (alwaysInnerParens) {
                this.out.print(")");
            }
            this.out.print("{");
            if (pathMod.getMin() != -1L) {
                this.out.print(Long.toString(pathMod.getMin()));
            }
            this.out.print(",");
            if (pathMod.getMax() != -1L) {
                this.out.print(Long.toString(pathMod.getMax()));
            }
            this.out.print("}");
            if (this.needParens) {
                this.out.print(")");
            }
        }

        public void visit(P_FixedLength pFixedLength) {
            if (this.needParens) {
                this.out.print("(");
            }
            if (alwaysInnerParens) {
                this.out.print("(");
            }
            pFixedLength.getSubPath().visit(this);
            if (alwaysInnerParens) {
                this.out.print(")");
            }
            this.out.print("{");
            this.out.print(Long.toString(pFixedLength.getCount()));
            this.out.print("}");
            if (this.needParens) {
                this.out.print(")");
            }
        }

        public void visit(P_ZeroOrOne path) {
            this.printPathMod("?", path.getSubPath());
        }

        public void visit(P_ZeroOrMore path) {
            this.printPathMod("*", path.getSubPath());
        }

        public void visit(P_OneOrMore path) {
            this.printPathMod("+", path.getSubPath());
        }

        private void printPathMod(String mod, Path path) {
            boolean doParens;
            boolean bl = doParens = this.needParens || alwaysInnerParens;
            if (doParens) {
                this.out.print("(");
            }
            path.visit(this);
            if (doParens) {
                this.out.print(")");
            }
            this.out.print(mod);
        }

        public void visit(P_Inverse inversePath) {
            this.out.print("^");
            Path p = inversePath.getSubPath();
            boolean parens = true;
            if (p instanceof P_Link) {
                parens = false;
            }
            this.visitPath(p, parens);
        }
    }
}

