/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.service.registries;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.suggestbox.service.descriptors.SuggestionHandlerDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class SuggestionHandlerRegistry
extends ContributionFragmentRegistry<SuggestionHandlerDescriptor> {
    private static final Log log = LogFactory.getLog(SuggestionHandlerRegistry.class);
    protected final Map<String, SuggestionHandlerDescriptor> suggestionHandlerDescriptors = new LinkedHashMap<String, SuggestionHandlerDescriptor>();

    public Collection<SuggestionHandlerDescriptor> getHandlers() {
        return this.suggestionHandlerDescriptors.values();
    }

    public SuggestionHandlerDescriptor getSuggestionHandlerDescriptor(String name) {
        return this.suggestionHandlerDescriptors.get(name);
    }

    public void contributionRemoved(String id, SuggestionHandlerDescriptor descriptor) {
        log.trace((Object)String.format("Removing contribution with id %s from suggestion handler descriptors", id));
        this.suggestionHandlerDescriptors.remove(id);
    }

    public String getContributionId(SuggestionHandlerDescriptor descriptor) {
        return descriptor.getName();
    }

    public void contributionUpdated(String id, SuggestionHandlerDescriptor contrib, SuggestionHandlerDescriptor newOrigContrib) {
        if (contrib.isEnabled()) {
            log.trace((Object)String.format("Putting contribution %s with id %s in suggestion handler descriptors", contrib, id));
            this.suggestionHandlerDescriptors.put(id, contrib);
        } else {
            log.trace((Object)String.format("Removing disabled contribution with id %s from suggestion handler descriptors", id));
            this.suggestionHandlerDescriptors.remove(id);
        }
    }

    public SuggestionHandlerDescriptor clone(SuggestionHandlerDescriptor suggester) {
        try {
            return (SuggestionHandlerDescriptor)suggester.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void merge(SuggestionHandlerDescriptor src, SuggestionHandlerDescriptor dst) {
        log.trace((Object)String.format("Merging contribution with id %s to contribution with id %s", src.getName(), dst.getName()));
        if (src.isEnabled() != dst.isEnabled()) {
            dst.setEnabled(src.isEnabled());
        }
        if (!StringUtils.isEmpty((CharSequence)src.getType()) && !src.getType().equals(dst.getType())) {
            dst.setType(src.getType());
        }
        if (!StringUtils.isEmpty((CharSequence)src.getSuggesterGroup()) && !src.getSuggesterGroup().equals(dst.getSuggesterGroup())) {
            dst.setSuggesterGroup(src.getSuggesterGroup());
        }
        if (!StringUtils.isEmpty((CharSequence)src.getOperation()) && !src.getOperation().equals(dst.getOperation())) {
            dst.setOperation(src.getOperation());
        }
        if (!StringUtils.isEmpty((CharSequence)src.getOperationChain()) && !src.getOperationChain().equals(dst.getOperationChain())) {
            dst.setOperationChain(src.getOperationChain());
        }
    }
}

