/*
 * Decompiled with CFR 0.152.
 */
package java_cup;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java_cup.runtime.Symbol;
import java_cup.sym;

public class ErrorManager {
    private static ErrorManager errorManager = new ErrorManager();
    private int errors = 0;
    private int warnings = 0;

    public void emit_warning(String message) {
        System.err.println("Warning " + message);
        ++this.warnings;
    }

    public void emit_warning(String message, Symbol sym2) {
        this.emit_warning(message + " at Symbol: " + ErrorManager.convSymbol(sym2) + " in line " + sym2.left + " / column " + sym2.right);
    }

    public static String convSymbol(Symbol symbol2) {
        String result = symbol2.value == null ? "" : " (\"" + symbol2.value.toString() + "\")";
        Field[] fields = sym.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!Modifier.isPublic(fields[i].getModifiers())) continue;
            try {
                if (fields[i].getInt(null) != symbol2.sym) continue;
                return fields[i].getName() + result;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return symbol2.toString() + result;
    }

    public int getErrorCount() {
        return this.errors;
    }

    public int getWarningCount() {
        return this.warnings;
    }

    public void emit_error(String message) {
        System.err.println("Error " + message);
        ++this.errors;
    }

    public void emit_error(String message, Symbol sym2) {
        this.emit_error(message + " at Symbol: " + ErrorManager.convSymbol(sym2) + " in line " + sym2.left + " / column " + sym2.right);
    }

    private ErrorManager() {
    }

    public static ErrorManager getManager() {
        return errorManager;
    }
}

