/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.factory;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.factory.XmlModelFactory;
import ro.isdc.wro.model.resource.support.AbstractConfigurableSingleStrategy;
import ro.isdc.wro.model.spi.ModelFactoryProvider;

public class ConfigurableModelFactory
extends AbstractConfigurableSingleStrategy<WroModelFactory, ModelFactoryProvider>
implements WroModelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableModelFactory.class);
    public static final String KEY = "modelFactory";

    @Override
    protected WroModelFactory getDefaultStrategy() {
        try {
            LOG.debug("Trying to use SmartWroModelFactory as default model factory");
            Class<WroModelFactory> smartFactoryClass = Class.forName("ro.isdc.wro.extensions.model.factory.SmartWroModelFactory").asSubclass(WroModelFactory.class);
            return smartFactoryClass.newInstance();
        }
        catch (Exception e) {
            LOG.debug("SmartWroModelFactory is not available. Using default model factory.");
            LOG.debug("Reason: {}", (Object)e.getMessage());
            return new XmlModelFactory();
        }
    }

    @Override
    protected Map<String, WroModelFactory> getStrategies(ModelFactoryProvider provider) {
        return provider.provideModelFactories();
    }

    @Override
    protected Class<ModelFactoryProvider> getProviderClass() {
        return ModelFactoryProvider.class;
    }

    @Override
    protected String getStrategyKey() {
        return KEY;
    }

    @Override
    public WroModel create() {
        return (WroModel)((WroModelFactory)this.getConfiguredStrategy()).create();
    }

    @Override
    public void destroy() {
        ((WroModelFactory)this.getConfiguredStrategy()).destroy();
    }
}

