/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.locator.UrlUriLocator;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.ImportAware;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.support.CssImportInspector;
import ro.isdc.wro.util.StringUtils;
import ro.isdc.wro.util.WroUtil;

@SupportedResourceType(value=ResourceType.CSS)
public abstract class AbstractCssImportPreProcessor
implements ResourcePreProcessor,
ImportAware {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCssImportPreProcessor.class);
    @Inject
    private UriLocatorFactory uriLocatorFactory;
    private final Map<String, Pair<List<String>, Stack<String>>> contextMap = new ConcurrentHashMap<String, Pair<List<String>, Stack<String>>>(){

        @Override
        public Pair<List<String>, Stack<String>> get(Object key) {
            Pair result = (Pair)super.get(key);
            if (result == null) {
                ArrayList list = new ArrayList();
                result = ImmutablePair.of(list, new Stack());
                this.put(key.toString(), result);
            }
            return result;
        }
    };

    protected final Map<String, Pair<List<String>, Stack<String>>> getContextMap() {
        return this.contextMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void process(Resource resource, Reader reader, Writer writer) throws IOException {
        LOG.debug("Applying {} processor", (Object)this.toString());
        this.validate();
        try {
            String result = this.parseCss(resource, IOUtils.toString((Reader)reader));
            writer.write(result);
        }
        finally {
            this.clearProcessedImports();
            reader.close();
            writer.close();
        }
    }

    private void validate() {
        Validate.notNull((Object)this.uriLocatorFactory);
    }

    private String parseCss(Resource resource, String cssContent) throws IOException {
        if (this.isImportProcessed(resource.getUri())) {
            LOG.debug("[WARN] Recursive import detected: {}", (Object)resource);
            this.onRecursiveImportDetected();
            return "";
        }
        String importedUri = resource.getUri().replace(File.separatorChar, '/');
        this.addProcessedImport(importedUri);
        List<Resource> importedResources = this.findImportedResources(resource.getUri(), cssContent);
        return this.doTransform(cssContent, importedResources);
    }

    private boolean isImportProcessed(String uri) {
        return this.getProcessedImports().contains(uri);
    }

    private void addProcessedImport(String importedUri) {
        String correlationId = Context.getCorrelationId();
        ((Stack)this.contextMap.get(correlationId).getValue()).push(importedUri);
        this.getProcessedImports().add(importedUri);
    }

    private List<String> getProcessedImports() {
        return (List)this.contextMap.get(Context.getCorrelationId()).getKey();
    }

    private void clearProcessedImports() {
        String correlationId = Context.getCorrelationId();
        Stack stack = (Stack)this.contextMap.get(correlationId).getValue();
        if (!stack.isEmpty()) {
            stack.pop();
        }
        if (stack.isEmpty()) {
            this.contextMap.remove(correlationId);
        }
    }

    private List<Resource> findImportedResources(String resourceUri, String cssContent) throws IOException {
        ArrayList<Resource> imports = new ArrayList<Resource>();
        String css = cssContent;
        List<String> foundImports = this.findImports(css);
        for (String importUrl : foundImports) {
            Resource importedResource = this.createImportedResource(resourceUri, importUrl);
            if (imports.contains(importedResource)) {
                LOG.debug("[WARN] Duplicate imported resource: {}", (Object)importedResource);
                continue;
            }
            imports.add(importedResource);
            this.onImportDetected(importedResource.getUri());
        }
        return imports;
    }

    protected List<String> findImports(String css) {
        return new CssImportInspector(css).findImports();
    }

    private Resource createImportedResource(String resourceUri, String importUrl) {
        String absoluteUrl = UrlUriLocator.isValid(importUrl) ? importUrl : this.computeAbsoluteUrl(resourceUri, importUrl);
        return Resource.create(absoluteUrl, ResourceType.CSS);
    }

    private String computeAbsoluteUrl(String relativeResourceUri, String importUrl) {
        String folder = WroUtil.getFullPath(relativeResourceUri);
        return StringUtils.cleanPath(folder + importUrl);
    }

    protected abstract String doTransform(String var1, List<Resource> var2) throws IOException;

    protected void onImportDetected(String foundImportUri) {
    }

    protected void onRecursiveImportDetected() {
    }

    @Override
    public boolean isImportAware() {
        return true;
    }
}

