/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.support.CssCompressor;

@Minimize
@SupportedResourceType(value=ResourceType.CSS)
public class CssCompressorProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CssCompressorProcessor.class);
    public static final String ALIAS = "cssCompressor";

    @Override
    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    @Override
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        try {
            new CssCompressor(reader).compress(writer, -1);
            writer.flush();
        }
        catch (Exception e) {
            String resourceUri = resource == null ? "" : "[" + resource.getUri() + "]";
            String message = "Exception while applying " + this.getClass().getSimpleName() + " processor on the " + resourceUri + " resource";
            LOG.error(message, (Throwable)e);
            throw new IOException(message);
        }
        finally {
            reader.close();
            writer.close();
        }
    }
}

