/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.support.hash;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import ro.isdc.wro.model.resource.support.AbstractConfigurableSingleStrategy;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;
import ro.isdc.wro.model.resource.support.hash.HashStrategyProvider;
import ro.isdc.wro.model.resource.support.hash.SHA1HashStrategy;

public class ConfigurableHashStrategy
extends AbstractConfigurableSingleStrategy<HashStrategy, HashStrategyProvider>
implements HashStrategy {
    public static final String KEY = "hashStrategy";

    @Override
    public String getHash(InputStream inputStream) throws IOException {
        try {
            String string = ((HashStrategy)this.getConfiguredStrategy()).getHash(inputStream);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    @Override
    protected String getStrategyKey() {
        return KEY;
    }

    @Override
    protected HashStrategy getDefaultStrategy() {
        return new SHA1HashStrategy();
    }

    @Override
    protected Map<String, HashStrategy> getStrategies(HashStrategyProvider provider) {
        return provider.provideHashStrategies();
    }

    @Override
    protected Class<HashStrategyProvider> getProviderClass() {
        return HashStrategyProvider.class;
    }
}

