/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.DefaultDirectoryServiceConfiguration;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.DirectoryServiceListener;
import org.apache.directory.server.core.authz.AuthorizationService;
import org.apache.directory.server.core.configuration.Configuration;
import org.apache.directory.server.core.configuration.ConfigurationException;
import org.apache.directory.server.core.configuration.MutablePartitionConfiguration;
import org.apache.directory.server.core.configuration.PartitionConfiguration;
import org.apache.directory.server.core.configuration.StartupConfiguration;
import org.apache.directory.server.core.interceptor.Interceptor;
import org.apache.directory.server.core.interceptor.InterceptorChain;
import org.apache.directory.server.core.interceptor.context.AddContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.jndi.AbstractContextFactory;
import org.apache.directory.server.core.jndi.DeadContext;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.core.partition.DefaultPartitionNexus;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.schema.PartitionSchemaLoader;
import org.apache.directory.server.core.schema.SchemaManager;
import org.apache.directory.server.core.schema.SchemaPartitionDao;
import org.apache.directory.server.schema.SerializableComparator;
import org.apache.directory.server.schema.bootstrap.ApacheSchema;
import org.apache.directory.server.schema.bootstrap.ApachemetaSchema;
import org.apache.directory.server.schema.bootstrap.BootstrapSchemaLoader;
import org.apache.directory.server.schema.bootstrap.CoreSchema;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.bootstrap.SystemSchema;
import org.apache.directory.server.schema.bootstrap.partition.DbFileListing;
import org.apache.directory.server.schema.bootstrap.partition.SchemaPartitionExtractor;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.ComparatorRegistry;
import org.apache.directory.server.schema.registries.DefaultOidRegistry;
import org.apache.directory.server.schema.registries.DefaultRegistries;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.schema.registries.SchemaLoader;
import org.apache.directory.shared.ldap.exception.LdapAuthenticationNotSupportedException;
import org.apache.directory.shared.ldap.exception.LdapConfigurationException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.ldif.Entry;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.DateUtils;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultDirectoryService
extends DirectoryService {
    private static final Logger log = LoggerFactory.getLogger(DefaultDirectoryService.class);
    private static final String BINARY_KEY = "java.naming.ldap.attributes.binary";
    private final String instanceId;
    private final DirectoryServiceConfiguration configuration = new DefaultDirectoryServiceConfiguration(this);
    private DirectoryServiceListener serviceListener;
    private SchemaManager schemaManager;
    private Hashtable<String, Object> environment;
    private StartupConfiguration startupConfiguration;
    private Registries registries;
    private DefaultPartitionNexus partitionNexus;
    private boolean firstStart;
    private InterceptorChain interceptorChain;
    private boolean started = false;

    public DefaultDirectoryService(String instanceId) {
        if (instanceId == null) {
            throw new NullPointerException("instanceId");
        }
        this.instanceId = instanceId;
    }

    @Override
    public Context getJndiContext(String rootDN) throws NamingException {
        return this.getJndiContext(null, null, null, "none", rootDN);
    }

    @Override
    public synchronized Context getJndiContext(LdapDN principalDn, String principal, byte[] credential, String authentication, String rootDN) throws NamingException {
        this.checkSecuritySettings(principal, credential, authentication);
        if (!this.started) {
            return new DeadContext();
        }
        Hashtable<String, Object> environment = this.getEnvironment();
        environment.remove("java.naming.security.principal");
        environment.remove("java.naming.security.credentials");
        environment.remove("java.naming.security.authentication");
        if (principal != null) {
            environment.put("java.naming.security.principal", principal);
        }
        if (credential != null) {
            environment.put("java.naming.security.credentials", credential);
        }
        if (authentication != null) {
            environment.put("java.naming.security.authentication", authentication);
        }
        if (rootDN == null) {
            rootDN = "";
        }
        environment.put("java.naming.provider.url", rootDN);
        return new ServerLdapContext(this, environment);
    }

    public synchronized void startup(DirectoryServiceListener listener, Hashtable env) throws NamingException {
        if (this.started) {
            return;
        }
        Hashtable envCopy = (Hashtable)env.clone();
        StartupConfiguration cfg = (StartupConfiguration)Configuration.toConfiguration(env);
        if (cfg.isShutdownHookEnabled()) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                public void run() {
                    try {
                        DefaultDirectoryService.this.shutdown();
                    }
                    catch (NamingException e) {
                        log.warn("Failed to shut down the directory service: " + DefaultDirectoryService.this.instanceId, (Throwable)e);
                    }
                }
            }, "ApacheDS Shutdown Hook (" + this.instanceId + ')'));
            log.info("ApacheDS shutdown hook has been registered with the runtime.");
        } else if (log.isWarnEnabled()) {
            log.warn("ApacheDS shutdown hook has NOT been registered with the runtime.  This default setting for standalone operation has been overriden.");
        }
        envCopy.put("java.naming.provider.url", "");
        try {
            cfg.validate();
        }
        catch (ConfigurationException e) {
            LdapConfigurationException ne = new LdapConfigurationException("Invalid configuration.");
            ne.initCause(e);
            throw ne;
        }
        this.environment = envCopy;
        this.startupConfiguration = cfg;
        listener.beforeStartup(this);
        this.initialize();
        this.firstStart = this.createBootstrapEntries();
        this.showSecurityWarnings();
        this.serviceListener = listener;
        this.started = true;
        if (!this.startupConfiguration.getTestEntries().isEmpty()) {
            this.createTestEntries(env);
        }
        listener.afterStartup(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sync() throws NamingException {
        if (!this.started) {
            return;
        }
        this.serviceListener.beforeSync(this);
        try {
            this.partitionNexus.sync();
        }
        finally {
            this.serviceListener.afterSync(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() throws NamingException {
        if (!this.started) {
            return;
        }
        this.serviceListener.beforeShutdown(this);
        try {
            this.partitionNexus.sync();
            this.partitionNexus.destroy();
            this.interceptorChain.destroy();
            this.started = false;
        }
        finally {
            this.serviceListener.afterShutdown(this);
            this.environment = null;
            this.interceptorChain = null;
            this.startupConfiguration = null;
        }
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public DirectoryServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public Hashtable<String, Object> getEnvironment() {
        return (Hashtable)this.environment.clone();
    }

    public DirectoryServiceListener getServiceListener() {
        return this.serviceListener;
    }

    public StartupConfiguration getStartupConfiguration() {
        return this.startupConfiguration;
    }

    public Registries getRegistries() {
        return this.registries;
    }

    public PartitionNexus getPartitionNexus() {
        return this.partitionNexus;
    }

    public InterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    public boolean isFirstStart() {
        return this.firstStart;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    private void checkSecuritySettings(String principal, byte[] credential, String authentication) throws NamingException {
        if (authentication == null) {
            authentication = "";
        }
        if ("strong".equalsIgnoreCase(authentication)) {
            if (principal == null) {
                throw new LdapConfigurationException("missing required java.naming.security.principal property for strong authentication");
            }
        } else if ("simple".equalsIgnoreCase(authentication)) {
            if (credential == null) {
                throw new LdapConfigurationException("missing required java.naming.security.credentials property for simple authentication");
            }
            if (principal == null) {
                throw new LdapConfigurationException("missing required java.naming.security.principal property for simple authentication");
            }
        } else if ("none".equalsIgnoreCase(authentication)) {
            if (credential != null) {
                throw new LdapConfigurationException("ambiguous bind settings encountered where bind is anonymous yet java.naming.security.credentials property is set");
            }
            if (principal != null) {
                throw new LdapConfigurationException("ambiguous bind settings encountered where bind is anonymous yet java.naming.security.principal property is set");
            }
            if (!this.startupConfiguration.isAllowAnonymousAccess()) {
                throw new LdapNoPermissionException("Anonymous access disabled.");
            }
        } else {
            throw new LdapAuthenticationNotSupportedException("Unknown authentication type: '" + authentication + "'", ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED);
        }
    }

    private boolean createBootstrapEntries() throws NamingException {
        boolean firstStart = false;
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(PartitionNexus.getAdminName()))) {
            firstStart = true;
            AttributesImpl attributes = new AttributesImpl();
            AttributeImpl objectClass = new AttributeImpl("objectClass");
            objectClass.add("top");
            objectClass.add("person");
            objectClass.add("organizationalPerson");
            objectClass.add("inetOrgPerson");
            attributes.put((Attribute)objectClass);
            attributes.put("uid", "admin");
            attributes.put("userPassword", "secret");
            attributes.put("displayName", "Directory Superuser");
            attributes.put("cn", "system administrator");
            attributes.put("sn", "administrator");
            attributes.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            attributes.put("displayName", "Directory Superuser");
            this.partitionNexus.add(new AddOperationContext(PartitionNexus.getAdminName(), (Attributes)attributes));
        }
        Map oidsMap = this.configuration.getRegistries().getAttributeTypeRegistry().getNormalizerMapping();
        LdapDN userDn = new LdapDN("ou=users,ou=system");
        userDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(userDn))) {
            firstStart = true;
            AttributesImpl attributes = new AttributesImpl();
            AttributeImpl objectClass = new AttributeImpl("objectClass");
            objectClass.add("top");
            objectClass.add("organizationalUnit");
            attributes.put((Attribute)objectClass);
            attributes.put("ou", "users");
            attributes.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            this.partitionNexus.add(new AddOperationContext(userDn, (Attributes)attributes));
        }
        LdapDN groupDn = new LdapDN("ou=groups,ou=system");
        groupDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(groupDn))) {
            firstStart = true;
            AttributesImpl attributes = new AttributesImpl();
            AttributeImpl objectClass = new AttributeImpl("objectClass");
            objectClass.add("top");
            objectClass.add("organizationalUnit");
            attributes.put((Attribute)objectClass);
            attributes.put("ou", "groups");
            attributes.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            this.partitionNexus.add(new AddOperationContext(groupDn, (Attributes)attributes));
        }
        LdapDN name = new LdapDN("cn=Administrators,ou=groups,ou=system");
        name.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(name))) {
            firstStart = true;
            AttributesImpl attributes = new AttributesImpl();
            AttributeImpl objectClass = new AttributeImpl("objectClass");
            objectClass.add("top");
            objectClass.add("groupOfUniqueNames");
            attributes.put((Attribute)objectClass);
            attributes.put("cn", "Administrators");
            attributes.put("uniqueMember", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            this.partitionNexus.add(new AddOperationContext(name, (Attributes)attributes));
            Interceptor authzInterceptor = this.interceptorChain.get("authorizationService");
            if (authzInterceptor == null) {
                log.error("The Authorization service is null : this is not allowed");
                throw new NamingException("The Authorization service is null");
            }
            if (!(authzInterceptor instanceof AuthorizationService)) {
                log.error("The Authorization service is not set correctly : '{}' is an incorect interceptor", (Object)authzInterceptor.getClass().getName());
                throw new NamingException("The Authorization service is incorrectly set");
            }
            AuthorizationService authzSrvc = (AuthorizationService)authzInterceptor;
            authzSrvc.cacheNewGroup(name, (Attributes)attributes);
        }
        LdapDN configurationDn = new LdapDN("ou=configuration,ou=system");
        configurationDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(configurationDn))) {
            firstStart = true;
            AttributesImpl attributes = new AttributesImpl();
            AttributeImpl objectClass = new AttributeImpl("objectClass");
            objectClass.add("top");
            objectClass.add("organizationalUnit");
            attributes.put((Attribute)objectClass);
            attributes.put("ou", "configuration");
            attributes.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            this.partitionNexus.add(new AddOperationContext(configurationDn, (Attributes)attributes));
        }
        LdapDN partitionsDn = new LdapDN("ou=partitions,ou=configuration,ou=system");
        partitionsDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(partitionsDn))) {
            firstStart = true;
            AttributesImpl attributes = new AttributesImpl();
            AttributeImpl objectClass = new AttributeImpl("objectClass");
            objectClass.add("top");
            objectClass.add("organizationalUnit");
            attributes.put((Attribute)objectClass);
            attributes.put("ou", "partitions");
            attributes.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            this.partitionNexus.add(new AddOperationContext(partitionsDn, (Attributes)attributes));
        }
        LdapDN servicesDn = new LdapDN("ou=services,ou=configuration,ou=system");
        servicesDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(servicesDn))) {
            firstStart = true;
            AttributesImpl attributes = new AttributesImpl();
            AttributeImpl objectClass = new AttributeImpl("objectClass");
            objectClass.add("top");
            objectClass.add("organizationalUnit");
            attributes.put((Attribute)objectClass);
            attributes.put("ou", "services");
            attributes.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            this.partitionNexus.add(new AddOperationContext(servicesDn, (Attributes)attributes));
        }
        LdapDN interceptorsDn = new LdapDN("ou=interceptors,ou=configuration,ou=system");
        interceptorsDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(interceptorsDn))) {
            firstStart = true;
            AttributesImpl attributes = new AttributesImpl();
            AttributeImpl objectClass = new AttributeImpl("objectClass");
            objectClass.add("top");
            objectClass.add("organizationalUnit");
            attributes.put((Attribute)objectClass);
            attributes.put("ou", "interceptors");
            attributes.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            this.partitionNexus.add(new AddOperationContext(interceptorsDn, (Attributes)attributes));
        }
        LdapDN sysPrefRootDn = new LdapDN("prefNodeName=sysPrefRoot,ou=system");
        sysPrefRootDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(sysPrefRootDn))) {
            firstStart = true;
            AttributesImpl attributes = new AttributesImpl();
            AttributeImpl objectClass = new AttributeImpl("objectClass");
            objectClass.add("top");
            objectClass.add("organizationalUnit");
            attributes.put((Attribute)objectClass);
            attributes.put("objectClass", "extensibleObject");
            attributes.put("prefNodeName", "sysPrefRoot");
            attributes.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            this.partitionNexus.add(new AddOperationContext(sysPrefRootDn, (Attributes)attributes));
        }
        return firstStart;
    }

    private void showSecurityWarnings() throws NamingException {
        boolean needToChangeAdminPassword = false;
        LdapDN adminDn = new LdapDN("uid=admin,ou=system");
        adminDn.normalize(this.configuration.getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
        Attributes adminEntry = this.partitionNexus.lookup(new LookupOperationContext(adminDn));
        Object userPassword = adminEntry.get("userPassword").get();
        if (userPassword instanceof byte[]) {
            needToChangeAdminPassword = "secret".equals(new String((byte[])userPassword));
        } else if (userPassword.toString().equals("secret")) {
            needToChangeAdminPassword = "secret".equals(userPassword.toString());
        }
        if (needToChangeAdminPassword) {
            log.warn("You didn't change the admin password of directory service instance '" + this.instanceId + "'.  " + "Please update the admin password as soon as possible " + "to prevent a possible security breach.");
        }
    }

    private void createTestEntries(Hashtable<String, Object> env) throws NamingException {
        String principal = AbstractContextFactory.getPrincipal(env);
        byte[] credential = AbstractContextFactory.getCredential(env);
        String authentication = AbstractContextFactory.getAuthentication(env);
        LdapDN principalDn = new LdapDN(principal);
        ServerLdapContext ctx = (ServerLdapContext)this.getJndiContext(principalDn, principal, credential, authentication, "");
        Iterator<Entry> i = this.startupConfiguration.getTestEntries().iterator();
        while (i.hasNext()) {
            try {
                Entry entry = i.next().clone();
                Attributes attributes = entry.getAttributes();
                String dn = entry.getDn();
                try {
                    ctx.createSubcontext(dn, attributes);
                }
                catch (Exception e) {
                    log.warn(dn + " test entry already exists.", (Throwable)e);
                }
            }
            catch (CloneNotSupportedException cnse) {
                log.warn("Cannot clone the entry ", (Throwable)cnse);
            }
        }
    }

    private void initialize() throws NamingException {
        if (log.isDebugEnabled()) {
            log.debug("---> Initializing the DefaultDirectoryService ");
        }
        BootstrapSchemaLoader loader = new BootstrapSchemaLoader();
        DefaultOidRegistry oidRegistry = new DefaultOidRegistry();
        this.registries = new DefaultRegistries("bootstrap", (SchemaLoader)loader, (OidRegistry)oidRegistry);
        HashSet<Object> bootstrapSchemas = new HashSet<Object>();
        bootstrapSchemas.add(new ApachemetaSchema());
        bootstrapSchemas.add(new ApacheSchema());
        bootstrapSchemas.add(new CoreSchema());
        bootstrapSchemas.add(new SystemSchema());
        loader.loadWithDependencies(bootstrapSchemas, this.registries);
        List errors = this.registries.checkRefInteg();
        if (!errors.isEmpty()) {
            NamingException e = new NamingException();
            e.setRootCause((Throwable)errors.get(0));
            throw e;
        }
        SerializableComparator.setRegistry((ComparatorRegistry)this.registries.getComparatorRegistry());
        File schemaDirectory = new File(this.startupConfiguration.getWorkingDirectory(), "schema");
        SchemaPartitionExtractor extractor = null;
        if (!schemaDirectory.exists()) {
            try {
                extractor = new SchemaPartitionExtractor(this.startupConfiguration.getWorkingDirectory());
                extractor.extract();
            }
            catch (IOException e) {
                NamingException ne = new NamingException("Failed to extract pre-loaded schema partition.");
                ne.setRootCause(e);
                throw ne;
            }
        }
        MutablePartitionConfiguration schemaPartitionConfig = new MutablePartitionConfiguration();
        schemaPartitionConfig.setId("schema");
        schemaPartitionConfig.setCacheSize(1000);
        DbFileListing listing = null;
        try {
            listing = new DbFileListing();
        }
        catch (IOException e) {
            throw new LdapNamingException("Got IOException while trying to read DBFileListing: " + e.getMessage(), ResultCodeEnum.OTHER);
        }
        schemaPartitionConfig.setIndexedAttributes(listing.getIndexedAttributes());
        schemaPartitionConfig.setSuffix("ou=schema");
        AttributesImpl entry = new AttributesImpl();
        entry.put("objectClass", "top");
        entry.get("objectClass").add("organizationalUnit");
        entry.put("ou", "schema");
        schemaPartitionConfig.setContextEntry((Attributes)entry);
        JdbmPartition schemaPartition = new JdbmPartition();
        schemaPartition.init(this.configuration, schemaPartitionConfig);
        SchemaPartitionDao dao = new SchemaPartitionDao(schemaPartition, this.registries);
        Map<String, Schema> schemaMap = dao.getSchemas();
        PartitionConfiguration pc = this.startupConfiguration.getSystemPartitionConfiguration();
        HashSet<PartitionConfiguration> pcs = new HashSet<PartitionConfiguration>();
        if (pc != null) {
            pcs.add(pc);
        } else {
            log.warn("Encountered null configuration.");
        }
        pcs.addAll(this.startupConfiguration.getPartitionConfigurations());
        for (PartitionConfiguration pconf : pcs) {
            for (Object indexedAttr : pconf.getIndexedAttributes()) {
                String schemaName = dao.findSchema(indexedAttr.toString());
                if (schemaName == null) {
                    throw new NamingException("Index on unidentified attribute: " + indexedAttr.toString());
                }
                Schema schema = schemaMap.get(schemaName);
                if (!schema.isDisabled()) continue;
                dao.enableSchema(schemaName);
            }
        }
        PartitionSchemaLoader schemaLoader = new PartitionSchemaLoader(schemaPartition, this.registries);
        DefaultRegistries globalRegistries = new DefaultRegistries("global", (SchemaLoader)schemaLoader, (OidRegistry)oidRegistry);
        schemaLoader.loadEnabled((Registries)globalRegistries);
        this.registries = globalRegistries;
        SerializableComparator.setRegistry((ComparatorRegistry)globalRegistries.getComparatorRegistry());
        HashSet<String> binaries = new HashSet<String>();
        if (this.environment.containsKey(BINARY_KEY)) {
            String binaryIds;
            if (log.isInfoEnabled()) {
                log.info("Startup environment contains java.naming.ldap.attributes.binary");
            }
            if ((binaryIds = (String)this.environment.get(BINARY_KEY)) == null) {
                if (log.isWarnEnabled()) {
                    log.warn("java.naming.ldap.attributes.binary in startup environment contains null value.  Using only schema info to set binary attributeTypes.");
                }
            } else {
                if (!StringTools.isEmpty((String)binaryIds)) {
                    String[] binaryArray = binaryIds.split(" ");
                    for (int i = 0; i < binaryArray.length; ++i) {
                        binaries.add(StringTools.lowerCaseAscii((String)StringTools.trim((String)binaryArray[i])));
                    }
                }
                if (log.isInfoEnabled()) {
                    log.info("Setting binaries to union of schema defined binaries and those provided in java.naming.ldap.attributes.binary");
                }
            }
        }
        this.schemaManager = new SchemaManager((Registries)globalRegistries, schemaLoader, new SchemaPartitionDao(schemaPartition, this.registries));
        AttributeTypeRegistry registry = this.registries.getAttributeTypeRegistry();
        for (AttributeType type : registry) {
            if (type.getSyntax().isHumanReadable()) continue;
            binaries.add(type.getOid());
            String[] names = type.getNames();
            for (int ii = 0; ii < names.length; ++ii) {
                binaries.add(StringTools.lowerCaseAscii((String)StringTools.trim((String)names[ii])));
            }
        }
        this.environment.put(BINARY_KEY, binaries);
        if (log.isDebugEnabled()) {
            log.debug("binary ids used: " + binaries);
        }
        this.partitionNexus = new DefaultPartitionNexus((Attributes)new AttributesImpl());
        this.partitionNexus.init(this.configuration, null);
        this.partitionNexus.addContextPartition(new AddContextPartitionOperationContext(schemaPartitionConfig, schemaPartition));
        this.interceptorChain = new InterceptorChain();
        this.interceptorChain.init(this.configuration);
        if (log.isDebugEnabled()) {
            log.debug("<--- DefaultDirectoryService initialized");
        }
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }
}

