/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.event;

import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.server.core.event.LeafEvaluator;
import org.apache.directory.server.core.event.SubstringEvaluator;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;

public class ExpressionEvaluator
implements Evaluator {
    private LeafEvaluator leafEvaluator;

    public ExpressionEvaluator(LeafEvaluator leafEvaluator) {
        this.leafEvaluator = leafEvaluator;
    }

    public ExpressionEvaluator(OidRegistry oidRegistry, AttributeTypeRegistry attributeTypeRegistry) throws NamingException {
        SubstringEvaluator substringEvaluator = null;
        substringEvaluator = new SubstringEvaluator(oidRegistry, attributeTypeRegistry);
        this.leafEvaluator = new LeafEvaluator(oidRegistry, attributeTypeRegistry, substringEvaluator);
    }

    public LeafEvaluator getLeafEvaluator() {
        return this.leafEvaluator;
    }

    public boolean evaluate(ExprNode node, String dn, Attributes entry) throws NamingException {
        if (node.isLeaf()) {
            return this.leafEvaluator.evaluate(node, dn, entry);
        }
        BranchNode bnode = (BranchNode)node;
        switch (bnode.getOperator()) {
            case OR: {
                for (ExprNode child : bnode.getChildren()) {
                    if (!this.evaluate(child, dn, entry)) continue;
                    return true;
                }
                return false;
            }
            case AND: {
                for (ExprNode child : bnode.getChildren()) {
                    if (this.evaluate(child, dn, entry)) continue;
                    return false;
                }
                return true;
            }
            case NOT: {
                if (null != bnode.getChild()) {
                    return !this.evaluate(bnode.getChild(), dn, entry);
                }
                throw new NamingException("Negation has no child: " + node);
            }
        }
        throw new NamingException("Unrecognized branch node operator: " + bnode.getOperator());
    }
}

