/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class LatestCreatedUsersOrGroupsPageProvider
extends AbstractPageProvider<DocumentModel> {
    private static final long serialVersionUID = 1L;
    public static final String LATEST_CREATED_USERS_OR_GROUPS_PROVIDER = "LATEST_CREATED_USERS_OR_GROUPS_PROVIDER";
    public static final String LATEST_AUDITED_CREATED_USERS_OR_GROUPS_PROVIDER = "LATEST_AUDITED_CREATED_USERS_OR_GROUPS_PROVIDER";
    protected static final String CORE_SESSION_PROPERTY = "coreSession";
    protected static final String POWER_USERS_GROUP = "powerusers";
    protected List<DocumentModel> currentPage;

    public List<DocumentModel> getCurrentPage() {
        if (this.currentPage != null) {
            return this.currentPage;
        }
        this.currentPage = new ArrayList<DocumentModel>();
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        CoreSession coreSession = (CoreSession)this.getProperties().get(CORE_SESSION_PROPERTY);
        if (coreSession == null || !this.canSearchUsersAndGroups(coreSession.getPrincipal())) {
            return Collections.emptyList();
        }
        PageProvider pp = pps.getPageProvider(LATEST_AUDITED_CREATED_USERS_OR_GROUPS_PROVIDER, null, Long.valueOf(this.getPageSize()), Long.valueOf(this.getCurrentPageIndex()), this.getProperties(), new Object[]{coreSession.getRootDocument().getId()});
        List entries = pp.getCurrentPage();
        if (entries != null) {
            UserManager um = (UserManager)Framework.getService(UserManager.class);
            DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
            try (Session userDir = directoryService.open(um.getUserDirectoryName(), null);){
                for (LogEntry e : entries) {
                    DocumentModel doc;
                    String id = (String)((Object)((ExtendedInfo)e.getExtendedInfos().get("id")).getSerializableValue());
                    if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                    if ("group_created".equals(e.getEventId())) {
                        doc = um.getGroupModel(id);
                    } else {
                        if (!"user_created".equals(e.getEventId())) continue;
                        doc = um.getUserModel(id);
                    }
                    if (doc == null) continue;
                    this.currentPage.add(doc);
                }
            }
        }
        return this.currentPage;
    }

    protected void pageChanged() {
        this.currentPage = null;
        super.pageChanged();
    }

    public long getResultsCountLimit() {
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        PageProvider pp = pps.getPageProvider(LATEST_AUDITED_CREATED_USERS_OR_GROUPS_PROVIDER, null, null, null, null, null);
        return pp.getResultsCountLimit();
    }

    protected boolean canSearchUsersAndGroups(NuxeoPrincipal principal) {
        return principal.isAdministrator() || principal.isMemberOf(POWER_USERS_GROUP);
    }
}

