/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.memory;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.memory.MemoryDirectoryDescriptor;
import org.nuxeo.ecm.directory.memory.MemoryDirectorySession;
import org.nuxeo.runtime.api.Framework;

public class MemoryDirectory
extends AbstractDirectory {
    public final Set<String> schemaSet;
    protected final Map<String, Map<String, Object>> data;

    public MemoryDirectory(MemoryDirectoryDescriptor descriptor) {
        super(descriptor, null);
        Set<String> schemaSet = descriptor.schemaSet;
        if (schemaSet == null) {
            Schema schema = ((SchemaManager)Framework.getService(SchemaManager.class)).getSchema(this.getSchema());
            if (schema == null) {
                throw new DirectoryException("Unknown schema :" + this.getSchema());
            }
            schemaSet = new HashSet<String>();
            for (Field field : schema.getFields()) {
                schemaSet.add(field.getName().getLocalName());
            }
        }
        this.schemaSet = schemaSet;
        this.data = Collections.synchronizedMap(new LinkedHashMap());
    }

    public MemoryDirectoryDescriptor getDescriptor() {
        return (MemoryDirectoryDescriptor)this.descriptor;
    }

    public MemoryDirectorySession getSession() {
        MemoryDirectorySession session = new MemoryDirectorySession(this);
        this.addSession((Session)session);
        return session;
    }
}

