/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth.tokens;

import java.util.Calendar;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.oauth.tokens.OAuthToken;

public class NuxeoOAuthToken
implements OAuthToken {
    public static final String SCHEMA = "oauthToken";
    protected String appId;
    protected String callbackUrl;
    protected String nuxeoLogin;
    protected String token;
    protected String tokenSecret;
    protected String consumerKey;
    protected OAuthToken.Type type;
    protected Calendar creationDate;
    protected String verifier;
    protected long durationInMinutes;
    protected boolean clientToken = false;
    protected String clientId;

    public NuxeoOAuthToken(String consumerKey, String callBack) {
        this.appId = consumerKey;
        this.consumerKey = consumerKey;
        this.callbackUrl = callBack;
        this.creationDate = Calendar.getInstance();
    }

    public NuxeoOAuthToken(NuxeoOAuthToken originalToken) {
        this.appId = originalToken.appId;
        this.callbackUrl = originalToken.callbackUrl;
        this.nuxeoLogin = originalToken.nuxeoLogin;
        this.token = originalToken.token;
        this.tokenSecret = originalToken.tokenSecret;
        this.consumerKey = originalToken.consumerKey;
        this.type = originalToken.type;
        this.verifier = originalToken.verifier;
        this.durationInMinutes = originalToken.durationInMinutes;
        this.creationDate = Calendar.getInstance();
    }

    public NuxeoOAuthToken(DocumentModel entry) {
        this.appId = (String)entry.getProperty(SCHEMA, "appId");
        this.callbackUrl = (String)entry.getProperty(SCHEMA, "callbackUrl");
        this.nuxeoLogin = (String)entry.getProperty(SCHEMA, "nuxeoLogin");
        this.token = (String)entry.getProperty(SCHEMA, "token");
        this.tokenSecret = (String)entry.getProperty(SCHEMA, "tokenSecret");
        this.consumerKey = (String)entry.getProperty(SCHEMA, "consumerKey");
        this.type = OAuthToken.Type.ACCESS;
        this.verifier = (String)entry.getProperty(SCHEMA, "verifier");
        this.durationInMinutes = (Long)entry.getProperty(SCHEMA, "durationInMinutes");
        this.creationDate = (Calendar)entry.getProperty(SCHEMA, "creationDate");
        Long clientTokenL = (Long)entry.getProperty(SCHEMA, "clientToken");
        if (Long.valueOf(1L).equals(clientTokenL)) {
            this.clientToken = true;
        }
        this.clientId = (String)entry.getProperty(SCHEMA, "clientId");
    }

    public void updateEntry(DocumentModel entry) {
        entry.setProperty(SCHEMA, "appId", (Object)this.appId);
        entry.setProperty(SCHEMA, "callbackUrl", (Object)this.callbackUrl);
        entry.setProperty(SCHEMA, "nuxeoLogin", (Object)this.nuxeoLogin);
        entry.setProperty(SCHEMA, "tokenSecret", (Object)this.tokenSecret);
        entry.setProperty(SCHEMA, "consumerKey", (Object)this.consumerKey);
        entry.setProperty(SCHEMA, "verifier", (Object)this.verifier);
        entry.setProperty(SCHEMA, "durationInMinutes", (Object)this.durationInMinutes);
        entry.setProperty(SCHEMA, "creationDate", (Object)this.creationDate);
        entry.setProperty(SCHEMA, "clientId", (Object)this.clientId);
        if (this.clientToken) {
            entry.setProperty(SCHEMA, "clientToken", (Object)1);
        } else {
            entry.setProperty(SCHEMA, "clientToken", (Object)0);
        }
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    @Override
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @Override
    public String getNuxeoLogin() {
        return this.nuxeoLogin;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getTokenSecret() {
        return this.tokenSecret;
    }

    @Override
    public String getConsumerKey() {
        return this.consumerKey;
    }

    @Override
    public OAuthToken.Type getType() {
        return this.type;
    }

    @Override
    public Calendar getCreationDate() {
        return this.creationDate;
    }

    @Override
    public String getValue(String keyName) {
        return null;
    }

    @Override
    public void setValue(String keyName, String value) {
    }

    @Override
    public String getVerifier() {
        return this.verifier;
    }

    @Override
    public boolean isExpired() {
        return false;
    }

    @Override
    public void setNuxeoLogin(String login) {
        this.nuxeoLogin = login;
    }

    public boolean isClientToken() {
        return this.clientToken;
    }

    public String getClientId() {
        return this.clientId;
    }
}

