/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.avro;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.nuxeo.runtime.avro.AvroSchemaFactory;
import org.nuxeo.runtime.avro.AvroService;

public class AvroSchemaFactoryContext {
    protected final Map<Class<?>, AvroSchemaFactory<?>> factories = new HashMap();
    protected final Map<String, Schema> createdSchemas = new HashMap<String, Schema>();
    protected final AvroService service;

    protected AvroSchemaFactoryContext(AvroService service) {
        this.service = service;
    }

    public <T> Schema createSchema(T input) {
        String qualifiedName = this.getFactory(input).getQualifiedName(input);
        Schema schema = this.createdSchemas.get(qualifiedName);
        if (schema == null) {
            schema = this.getFactory(input).createSchema(input);
            this.createdSchemas.put(qualifiedName, schema);
        }
        return schema;
    }

    public AvroService getService() {
        return this.service;
    }

    public <U> List<U> sort(Collection<U> children) {
        if (children == null || children.isEmpty()) {
            return Collections.emptyList();
        }
        AvroSchemaFactory<U> factory = this.getFactory(children.iterator().next());
        if (factory == null) {
            return Collections.emptyList();
        }
        ArrayList<U> sortedChildren = new ArrayList<U>(children);
        sortedChildren.sort(Comparator.comparing(factory::getQualifiedName));
        return sortedChildren;
    }

    protected <T> AvroSchemaFactory<T> getFactory(T input) {
        AvroSchemaFactory<?> factory = this.factories.get(input.getClass());
        if (factory != null) {
            return factory;
        }
        for (Class<?> intrface : input.getClass().getInterfaces()) {
            factory = this.factories.get(intrface);
            if (factory == null) continue;
            return factory;
        }
        for (Map.Entry entry : this.factories.entrySet()) {
            if (!((Class)entry.getKey()).isAssignableFrom(input.getClass())) continue;
            return (AvroSchemaFactory)entry.getValue();
        }
        return null;
    }

    protected void register(Class<?> type, AvroSchemaFactory<?> factory) {
        this.factories.put(type, factory);
    }
}

