/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.db;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class Insert
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Dialect dialect;
    private final Table table;
    private final List<Column> columns;
    private Column idColumn;
    private String insertValues;

    public Insert(Table table) {
        this.table = table;
        this.dialect = table.getDialect();
        this.columns = new LinkedList<Column>();
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public void addIdentityColumn(Column idColumn) {
        this.idColumn = idColumn;
    }

    public void setValues(String insertValues) {
        this.insertValues = insertValues;
    }

    public String getStatement() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("INSERT INTO ");
        sb.append(this.table.getQuotedName());
        sb.append(' ');
        LinkedList<String> columnNames = new LinkedList<String>();
        LinkedList<String> values = new LinkedList<String>();
        for (Column column : this.columns) {
            columnNames.add(column.getQuotedName());
            values.add(column.getFreeVariableSetter());
        }
        if (columnNames.isEmpty()) {
            sb.append(this.dialect.getNoColumnsInsertString(this.idColumn));
        } else {
            sb.append('(');
            sb.append(String.join((CharSequence)", ", columnNames));
            sb.append(") ");
            if (this.insertValues == null) {
                sb.append("VALUES (");
                sb.append(String.join((CharSequence)", ", values));
                sb.append(')');
            } else {
                sb.append(this.insertValues);
            }
        }
        return sb.toString();
    }
}

