/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.kv;

import java.io.Serializable;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.function.ThrowableConsumer;
import org.nuxeo.common.function.ThrowableFunction;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.TableImpl;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectOracle;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectPostgreSQL;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectSQLServer;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.ConnectionHelper;
import org.nuxeo.runtime.kv.AbstractKeyValueStoreProvider;
import org.nuxeo.runtime.kv.KeyValueStoreDescriptor;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class SQLKeyValueStore
extends AbstractKeyValueStoreProvider {
    private static final Logger log = LogManager.getLogger(SQLKeyValueStore.class);
    public static final String DATASOURCE_PROP = "datasource";
    public static final String TABLE_PROP = "table";
    public static final String KEY_COL = "key";
    public static final String LONG_COL = "long";
    public static final String STRING_COL = "string";
    public static final String BYTES_COL = "bytes";
    public static final String TTL_COL = "ttl";
    protected static final int TTL_EXPIRATION_FREQUENCY_MS = 60000;
    protected static final int MAX_RETRY = 5;
    protected JDBCLogger logger;
    protected String dataSourceName;
    protected Dialect dialect;
    protected TableImpl table;
    protected Column keyCol;
    protected Column longCol;
    protected Column stringCol;
    protected Column bytesCol;
    protected Column ttlCol;
    protected String tableName;
    protected String keyColName;
    protected String longColName;
    protected String stringColName;
    protected String bytesColName;
    protected String ttlColName;
    protected Thread ttlThread;
    protected String getSQL;
    protected String getMultiSQL;
    protected String getLongSQL;
    protected String deleteAllSQL;
    protected String deleteSQL;
    protected String deleteIfLongSQL;
    protected String deleteIfStringSQL;
    protected String deleteIfBytesSQL;
    protected String expireSQL;
    protected String keyStreamSQL;
    protected String keyStreamPrefixSQL;
    protected String setTTLSQL;
    protected String existsSQL;
    protected String insertSQL;
    protected String insertLongSQL;
    protected String updateLongSQL;
    protected String updateReturningPostgreSQLSql;
    protected String updateReturningOracleSql;
    protected String updateReturningSQLServerSql;

    public void initialize(KeyValueStoreDescriptor descriptor) {
        super.initialize(descriptor);
        this.logger = new JDBCLogger(this.name);
        Map properties = descriptor.properties;
        this.dataSourceName = (String)properties.get(DATASOURCE_PROP);
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.dataSourceName})) {
            throw new NuxeoException("Missing datasource property in configuration");
        }
        String tableProp = (String)properties.get(TABLE_PROP);
        String namespace = descriptor.namespace;
        Object tbl = StringUtils.isBlank((CharSequence)tableProp) ? ((String)StringUtils.defaultIfBlank((CharSequence)namespace, (CharSequence)this.name)).trim() : (StringUtils.isBlank((CharSequence)namespace) ? tableProp.trim() : tableProp.trim() + "_" + namespace.trim());
        this.runWithConnection((ThrowableConsumer<Connection, SQLException>)((ThrowableConsumer)arg_0 -> this.lambda$initialize$0((String)tbl, arg_0)));
        this.prepareSQL();
        this.startTTLThread();
    }

    public void close() {
        this.stopTTLThread();
    }

    protected void getTable(Connection connection, String tbl) throws SQLException {
        String tablePhysicalName = this.dialect.getTableName(tbl);
        this.table = new TableImpl(this.dialect, tablePhysicalName, tablePhysicalName);
        this.keyCol = this.addColumn(KEY_COL, ColumnType.SYSNAME);
        this.keyCol.setPrimary(true);
        this.keyCol.setNullable(false);
        this.longCol = this.addColumn(LONG_COL, ColumnType.LONG);
        this.stringCol = this.addColumn(STRING_COL, ColumnType.CLOB);
        this.bytesCol = this.addColumn(BYTES_COL, ColumnType.BLOB);
        this.ttlCol = this.addColumn(TTL_COL, ColumnType.LONG);
        this.table.addIndex(TTL_COL);
        this.tableName = this.table.getQuotedName();
        this.keyColName = this.keyCol.getQuotedName();
        this.longColName = this.longCol.getQuotedName();
        this.stringColName = this.stringCol.getQuotedName();
        this.bytesColName = this.bytesCol.getQuotedName();
        this.ttlColName = this.ttlCol.getQuotedName();
        if (!this.tableExists(connection)) {
            this.createTable(connection);
        }
        this.checkColumns(connection);
    }

    protected Column addColumn(String columnName, ColumnType type) {
        String colPhysicalName = this.dialect.getColumnName(columnName);
        Column column = new Column(this.table, colPhysicalName, type, columnName);
        return this.table.addColumn(column.getKey(), column);
    }

    protected void prepareSQL() {
        this.getSQL = "SELECT " + this.longColName + ", " + this.stringColName + ", " + this.bytesColName + " FROM " + this.tableName + " WHERE " + this.keyColName + " = ?";
        this.getMultiSQL = "SELECT " + this.keyColName + ", " + this.longColName + ", " + this.stringColName + ", " + this.bytesColName + " FROM " + this.tableName + " WHERE " + this.keyColName + " IN (%s)";
        this.getLongSQL = "SELECT " + this.longColName + " FROM " + this.tableName + " WHERE " + this.keyColName + " = ?";
        this.deleteAllSQL = "DELETE FROM " + this.tableName;
        this.deleteSQL = "DELETE FROM " + this.tableName + " WHERE " + this.keyColName + " = ?";
        this.deleteIfLongSQL = this.deleteSQL + " AND " + this.longColName + " = ?";
        this.deleteIfStringSQL = this.deleteSQL + " AND " + this.dialect.getQuotedNameForExpression(this.stringCol) + " = ?";
        this.deleteIfBytesSQL = this.deleteSQL + " AND " + this.bytesColName + " = ?";
        this.expireSQL = "DELETE FROM " + this.tableName + " WHERE " + this.ttlColName + " < ?";
        this.keyStreamSQL = "SELECT " + this.keyColName + " FROM " + this.tableName;
        this.keyStreamPrefixSQL = this.keyStreamSQL + " WHERE " + this.keyColName + " LIKE ?";
        String esc = this.dialect.getLikeEscaping();
        if (esc != null) {
            this.keyStreamPrefixSQL = this.keyStreamPrefixSQL + esc;
        }
        this.setTTLSQL = "UPDATE " + this.tableName + " SET " + this.ttlColName + " = ? WHERE " + this.keyColName + " = ?";
        this.existsSQL = "SELECT 1 FROM " + this.tableName + " WHERE " + this.keyColName + " = ?";
        this.insertSQL = "INSERT INTO " + this.tableName + "(" + this.keyColName + ", " + this.longColName + ", " + this.stringColName + ", " + this.bytesColName + ", " + this.ttlColName + ") VALUES (?, ?, ?, ?, ?)";
        this.insertLongSQL = "INSERT INTO " + this.tableName + "(" + this.keyColName + ", " + this.longColName + ") VALUES (?, ?)";
        this.updateLongSQL = "UPDATE " + this.tableName + " SET " + this.longColName + " = ? WHERE " + this.keyColName + " = ? AND " + this.longColName + " = ?";
        this.updateReturningPostgreSQLSql = "UPDATE " + this.tableName + " SET " + this.longColName + " = " + this.longColName + " + ? WHERE " + this.keyColName + " = ? AND " + this.stringColName + " IS NULL AND " + this.bytesColName + " IS NULL RETURNING " + this.longColName;
        this.updateReturningOracleSql = "UPDATE " + this.tableName + " SET " + this.longColName + " = " + this.longColName + " + ? WHERE " + this.keyColName + " = ? AND " + this.stringColName + " IS NULL AND " + this.bytesColName + " IS NULL RETURNING " + this.longColName + " INTO ?";
        this.updateReturningSQLServerSql = "UPDATE " + this.tableName + " SET " + this.longColName + " = " + this.longColName + " + ? OUTPUT INSERTED." + this.longColName + " WHERE " + this.keyColName + " = ? AND " + this.stringColName + " IS NULL AND " + this.bytesColName + " IS NULL";
    }

    protected void startTTLThread() {
        this.ttlThread = new Thread(this::expireTTLThread);
        this.ttlThread.setName("Nuxeo-Expire-KeyValueStore-" + this.name);
        this.ttlThread.setDaemon(true);
        this.ttlThread.start();
    }

    protected void stopTTLThread() {
        if (this.ttlThread == null) {
            return;
        }
        this.ttlThread.interrupt();
        this.ttlThread = null;
    }

    protected void expireTTLThread() {
        log.debug("Starting TTL expiration thread for KeyValueStore: {}", (Object)this.name);
        try {
            Thread.sleep((long)(60000.0 * Math.random()));
            while (!Thread.currentThread().isInterrupted()) {
                Thread.sleep(60000L);
                this.expireTTLOnce();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        log.debug("Stopping TTL expiration thread for KeyValueStore: {}", (Object)this.name);
    }

    protected String escapeLike(String prefix) {
        return prefix.replace("\\", "\\\\").replace("%", "\\%").replace("_", "\\_");
    }

    protected Object toStorage(Object value) {
        if (value instanceof byte[]) {
            try {
                value = SQLKeyValueStore.bytesToString((byte[])((byte[])value));
            }
            catch (CharacterCodingException characterCodingException) {
                // empty catch block
            }
        }
        if (value instanceof String) {
            try {
                value = Long.valueOf((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    protected byte[] toBytes(Object value) {
        if (value instanceof String) {
            return ((String)value).getBytes(StandardCharsets.UTF_8);
        }
        if (value instanceof Long) {
            return ((Long)value).toString().getBytes(StandardCharsets.UTF_8);
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        return null;
    }

    protected String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Long) {
            return ((Long)value).toString();
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            try {
                return SQLKeyValueStore.bytesToString((byte[])bytes);
            }
            catch (CharacterCodingException e) {
                return null;
            }
        }
        return null;
    }

    protected Long toLong(Object value) throws NumberFormatException {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return SQLKeyValueStore.bytesToLong((byte[])bytes);
        }
        return null;
    }

    protected void runWithConnection(ThrowableConsumer<Connection, SQLException> consumer) {
        TransactionHelper.runWithoutTransaction(() -> {
            try (Connection connection = this.getConnection();){
                consumer.accept((Object)connection);
            }
            catch (SQLException e) {
                throw new NuxeoException((Throwable)e);
            }
        });
    }

    protected <R> R runWithConnection(ThrowableFunction<Connection, R, SQLException> function) {
        return (R)TransactionHelper.runWithoutTransaction(() -> {
            Object object;
            block8: {
                Connection connection = this.getConnection();
                try {
                    object = function.apply((Object)connection);
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new NuxeoException((Throwable)e);
                    }
                }
                connection.close();
            }
            return object;
        });
    }

    protected Connection getConnection() throws SQLException {
        return ConnectionHelper.getConnection((String)this.dataSourceName);
    }

    protected void setToPreparedStatement(String sql, PreparedStatement ps, Column column, Serializable value) throws SQLException {
        this.setToPreparedStatement(sql, ps, Arrays.asList(column), Arrays.asList(value));
    }

    protected void setToPreparedStatement(String sql, PreparedStatement ps, Column column1, Serializable value1, Column column2, Serializable value2) throws SQLException {
        this.setToPreparedStatement(sql, ps, Arrays.asList(column1, column2), Arrays.asList(value1, value2));
    }

    protected void setToPreparedStatement(String sql, PreparedStatement ps, Column column1, Serializable value1, Column column2, Serializable value2, Column column3, Serializable value3) throws SQLException {
        this.setToPreparedStatement(sql, ps, Arrays.asList(column1, column2, column3), Arrays.asList(value1, value2, value3));
    }

    protected void setToPreparedStatement(String sql, PreparedStatement ps, List<Column> columns, List<? extends Serializable> values) throws SQLException {
        if (columns.size() != values.size()) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < columns.size(); ++i) {
            columns.get(i).setToPreparedStatement(ps, i + 1, values.get(i));
        }
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, values);
        }
    }

    protected boolean tableExists(Connection connection) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        String schemaName = this.getDatabaseSchemaName(connection);
        try (ResultSet rs = metadata.getTables(null, schemaName, this.table.getPhysicalName(), new String[]{"TABLE"});){
            boolean exists = rs.next();
            log.trace("Checking if table {} exists: {}", (Object)this.table.getPhysicalName(), (Object)exists);
            boolean bl = exists;
            return bl;
        }
    }

    protected void createTable(Connection connection) throws SQLException {
        try (Statement st = connection.createStatement();){
            String createSQL = this.table.getCreateSql();
            this.logger.log(createSQL);
            st.execute(createSQL);
            for (String sql : this.table.getPostCreateSqls(null)) {
                this.logger.log(sql);
                st.execute(sql);
            }
        }
    }

    protected void checkColumns(Connection connection) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        String schemaName = this.getDatabaseSchemaName(connection);
        try (ResultSet rs = metadata.getColumns(null, schemaName, this.table.getPhysicalName(), "%");){
            while (rs.next()) {
                String schema = rs.getString("TABLE_SCHEM");
                if (schema != null && "INFORMATION_SCHEMA".equals(schema.toUpperCase())) continue;
                String columnName = rs.getString("COLUMN_NAME").toUpperCase();
                int actual = rs.getInt("DATA_TYPE");
                String actualName = rs.getString("TYPE_NAME");
                int actualSize = rs.getInt("COLUMN_SIZE");
                Column column = null;
                for (Column c : this.table.getColumns()) {
                    String upperName = c.getPhysicalName().toUpperCase();
                    if (!upperName.equals(columnName)) continue;
                    column = c;
                }
                if (column == null) {
                    log.error("Column not found: {} in table: {}", (Object)columnName, (Object)this.tableName);
                    continue;
                }
                String message = column.checkJdbcType(actual, actualName, actualSize);
                if (message == null) continue;
                log.error(message);
                Framework.getRuntime().getMessageHandler().addError(message);
            }
        }
    }

    protected String getDatabaseSchemaName(Connection connection) throws SQLException {
        String schemaName = null;
        if (this.dialect instanceof DialectOracle) {
            try (Statement st = connection.createStatement();){
                String sql = "SELECT SYS_CONTEXT('USERENV', 'SESSION_USER') FROM DUAL";
                this.logger.log(sql);
                try (ResultSet rs = st.executeQuery(sql);){
                    if (rs.next()) {
                        schemaName = rs.getString(1);
                        this.logger.log("  -> schema: " + schemaName);
                    }
                }
            }
        }
        return schemaName;
    }

    protected void expireTTLOnce() {
        this.runWithConnection((ThrowableConsumer<Connection, SQLException>)((ThrowableConsumer)connection -> {
            try (PreparedStatement ps = connection.prepareStatement(this.expireSQL);){
                Long ttlDeadline = this.getTTLValue(0L);
                this.setToPreparedStatement(this.expireSQL, ps, this.ttlCol, ttlDeadline);
                int count = ps.executeUpdate();
                this.logger.logCount(count);
            }
            catch (SQLException e) {
                if (this.dialect.isConcurrentUpdateException(e)) {
                    return;
                }
                log.debug("Exception during TTL expiration", (Throwable)e);
            }
        }));
    }

    public void clear() {
        this.runWithConnection((ThrowableConsumer<Connection, SQLException>)((ThrowableConsumer)connection -> {
            try (Statement st = connection.createStatement();){
                this.logger.log(this.deleteAllSQL);
                st.execute(this.deleteAllSQL);
            }
        }));
    }

    public Stream<String> keyStream() {
        return (Stream)this.runWithConnection(connection -> this.keyStream((Connection)connection, null));
    }

    public Stream<String> keyStream(String prefix) {
        return (Stream)this.runWithConnection(connection -> this.keyStream((Connection)connection, prefix));
    }

    protected Stream<String> keyStream(Connection connection, String prefix) throws SQLException {
        String sql = prefix == null ? this.keyStreamSQL : this.keyStreamPrefixSQL;
        ArrayList<String> keys = new ArrayList<String>();
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            if (prefix != null) {
                String like = this.escapeLike(prefix) + "%";
                this.setToPreparedStatement(sql, ps, this.keyCol, (Serializable)((Object)like));
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String key = (String)((Object)this.keyCol.getFromResultSet(rs, 1));
                    keys.add(key);
                }
            }
        }
        return keys.stream();
    }

    public byte[] get(String key) {
        Object value = this.getObject(key);
        if (value == null) {
            return null;
        }
        byte[] bytes = this.toBytes(value);
        if (bytes != null) {
            return bytes;
        }
        throw new UnsupportedOperationException(value.getClass().getName());
    }

    public String getString(String key) {
        Object value = this.getObject(key);
        if (value == null) {
            return null;
        }
        String string = this.toString(value);
        if (string != null) {
            return string;
        }
        throw new IllegalArgumentException("Value is not a String for key: " + key);
    }

    public Long getLong(String key) throws NumberFormatException {
        Object value = this.getObject(key);
        if (value == null) {
            return null;
        }
        Long longValue = this.toLong(value);
        if (longValue != null) {
            return longValue;
        }
        throw new NumberFormatException("Value is not a Long for key: " + key);
    }

    public Map<String, byte[]> get(Collection<String> keys) {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>(keys.size());
        this.getObjects(keys, (key, value) -> {
            byte[] bytes = this.toBytes(value);
            if (bytes == null) {
                throw new UnsupportedOperationException(String.format("Value of class %s is not supported for key: %s", value.getClass().getName(), key));
            }
            map.put((String)key, bytes);
        });
        return map;
    }

    public Map<String, String> getStrings(Collection<String> keys) {
        HashMap<String, String> map = new HashMap<String, String>(keys.size());
        this.getObjects(keys, (key, value) -> {
            String string = this.toString(value);
            if (string == null) {
                throw new IllegalArgumentException("Value is not a String for key: " + key);
            }
            map.put((String)key, string);
        });
        return map;
    }

    public Map<String, Long> getLongs(Collection<String> keys) throws NumberFormatException {
        HashMap<String, Long> map = new HashMap<String, Long>(keys.size());
        this.getObjects(keys, (key, value) -> {
            Long longValue = this.toLong(value);
            if (longValue == null) {
                throw new IllegalArgumentException("Value is not a Long for key: " + key);
            }
            map.put((String)key, longValue);
        });
        return map;
    }

    protected Object getObject(String key) {
        return this.runWithConnection(connection -> {
            try (PreparedStatement ps = connection.prepareStatement(this.getSQL);){
                byte[] byArray;
                block26: {
                    byte[] bytes;
                    ResultSet rs;
                    block24: {
                        Long l;
                        block25: {
                            Long longValue;
                            block22: {
                                String string;
                                block23: {
                                    block20: {
                                        Serializable serializable;
                                        block21: {
                                            this.setToPreparedStatement(this.getSQL, ps, this.keyCol, (Serializable)((Object)key));
                                            rs = ps.executeQuery();
                                            try {
                                                if (rs.next()) break block20;
                                                if (this.logger.isLogEnabled()) {
                                                    this.logger.log("  -> null");
                                                }
                                                serializable = null;
                                                if (rs == null) break block21;
                                            }
                                            catch (Throwable throwable) {
                                                if (rs != null) {
                                                    try {
                                                        rs.close();
                                                    }
                                                    catch (Throwable throwable2) {
                                                        throwable.addSuppressed(throwable2);
                                                    }
                                                }
                                                throw throwable;
                                            }
                                            rs.close();
                                        }
                                        return serializable;
                                    }
                                    longValue = (Long)this.longCol.getFromResultSet(rs, 1);
                                    String string2 = (String)((Object)this.stringCol.getFromResultSet(rs, 2));
                                    bytes = (byte[])this.bytesCol.getFromResultSet(rs, 3);
                                    if (this.logger.isLogEnabled()) {
                                        this.logger.logResultSet(rs, Arrays.asList(this.longCol, this.stringCol, this.bytesCol));
                                    }
                                    if (string2 == null) break block22;
                                    string = string2;
                                    if (rs == null) break block23;
                                    rs.close();
                                }
                                return string;
                            }
                            if (longValue == null) break block24;
                            l = longValue;
                            if (rs == null) break block25;
                            rs.close();
                        }
                        return l;
                    }
                    byArray = bytes;
                    if (rs == null) break block26;
                    rs.close();
                }
                return byArray;
            }
        });
    }

    protected void getObjects(Collection<String> keys, BiConsumer<String, Object> consumer) {
        if (keys.isEmpty()) {
            return;
        }
        this.runWithConnection((ThrowableConsumer<Connection, SQLException>)((ThrowableConsumer)connection -> {
            String sql = String.format(this.getMultiSQL, this.nParams(keys.size()));
            this.logger.logSQL(sql, keys);
            try (PreparedStatement ps = connection.prepareStatement(sql);){
                int i = 1;
                for (String key : keys) {
                    this.keyCol.setToPreparedStatement(ps, i++, (Serializable)((Object)key));
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        Object value;
                        String key;
                        key = (String)((Object)this.keyCol.getFromResultSet(rs, 1));
                        Long longVal = (Long)this.longCol.getFromResultSet(rs, 2);
                        String string = (String)((Object)this.stringCol.getFromResultSet(rs, 3));
                        byte[] bytes = (byte[])this.bytesCol.getFromResultSet(rs, 4);
                        if (this.logger.isLogEnabled()) {
                            this.logger.logResultSet(rs, Arrays.asList(this.keyCol, this.longCol, this.stringCol, this.bytesCol));
                        }
                        if ((value = string != null ? string : (longVal != null ? longVal : (Object)bytes)) == null) continue;
                        consumer.accept(key, value);
                    }
                }
            }
        }));
    }

    protected String nParams(int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append('?');
        }
        return sb.toString();
    }

    protected Long ttlToStorage(long ttl) {
        return ttl == 0L ? null : this.getTTLValue(ttl);
    }

    protected Long getTTLValue(long ttl) {
        return System.currentTimeMillis() / 1000L + ttl;
    }

    public void put(String key, byte[] bytes) {
        this.put(key, this.toStorage(bytes), 0L);
    }

    public void put(String key, byte[] bytes, long ttl) {
        this.put(key, this.toStorage(bytes), ttl);
    }

    public void put(String key, String string) {
        this.put(key, this.toStorage(string), 0L);
    }

    public void put(String key, String string, long ttl) {
        this.put(key, this.toStorage(string), ttl);
    }

    public void put(String key, Long value) {
        this.put(key, (Object)value, 0L);
    }

    public void put(String key, Long value, long ttl) {
        this.put(key, (Object)value, ttl);
    }

    protected void put(String key, Object value, long ttl) {
        this.runWithConnection((ThrowableConsumer<Connection, SQLException>)((ThrowableConsumer)connection -> {
            if (value == null) {
                try (PreparedStatement ps = connection.prepareStatement(this.deleteSQL);){
                    this.setToPreparedStatement(this.deleteSQL, ps, this.keyCol, (Serializable)((Object)key));
                    ps.execute();
                }
            }
            Long longValue = value instanceof Long ? (Long)value : null;
            String stringValue = value instanceof String ? (String)value : null;
            byte[] bytesValue = value instanceof byte[] ? (byte[])value : null;
            Long ttlValue = this.ttlToStorage(ttl);
            ArrayList<Column> psColumns = new ArrayList<Column>();
            ArrayList<Serializable> psValues = new ArrayList<Serializable>();
            String sql = this.dialect.getUpsertSql(Arrays.asList(this.keyCol, this.longCol, this.stringCol, this.bytesCol, this.ttlCol), Arrays.asList(key, longValue, stringValue, bytesValue, ttlValue), psColumns, psValues);
            for (int retry = 0; retry < 5; ++retry) {
                try {
                    try (PreparedStatement ps = connection.prepareStatement(sql);){
                        this.setToPreparedStatement(sql, ps, psColumns, psValues);
                        ps.execute();
                    }
                    return;
                }
                catch (SQLException e) {
                    if (!this.dialect.isConcurrentUpdateException(e)) {
                        throw e;
                    }
                    this.sleepBeforeRetry();
                    continue;
                }
            }
            throw new ConcurrentUpdateException("Failed to do atomic put for key: " + key);
        }));
    }

    public boolean setTTL(String key, long ttl) {
        return (Boolean)this.runWithConnection(connection -> {
            try (PreparedStatement ps = connection.prepareStatement(this.setTTLSQL);){
                this.setToPreparedStatement(this.setTTLSQL, ps, this.ttlCol, this.ttlToStorage(ttl), this.keyCol, (Serializable)((Object)key));
                int count = ps.executeUpdate();
                boolean set = count == 1;
                Boolean bl = set;
                return bl;
            }
        });
    }

    public boolean compareAndSet(String key, byte[] expected, byte[] value, long ttl) {
        return this.compareAndSet(key, this.toStorage(expected), this.toStorage(value), ttl);
    }

    public boolean compareAndSet(String key, String expected, String value, long ttl) {
        return this.compareAndSet(key, this.toStorage(expected), this.toStorage(value), ttl);
    }

    protected boolean compareAndSet(String key, Object expected, Object value, long ttl) {
        return (Boolean)this.runWithConnection(connection -> {
            Column valueCol;
            Column expectedCol;
            if (expected == null && value == null) {
                try (PreparedStatement ps = connection.prepareStatement(this.existsSQL);){
                    Boolean bl;
                    block45: {
                        this.setToPreparedStatement(this.existsSQL, ps, this.keyCol, (Serializable)((Object)key));
                        ResultSet rs = ps.executeQuery();
                        try {
                            boolean set;
                            boolean bl2 = set = !rs.next();
                            if (this.logger.isLogEnabled()) {
                                this.logger.log("  -> " + (set ? "NOP" : "FAILED"));
                            }
                            bl = set;
                            if (rs == null) break block45;
                        }
                        catch (Throwable set) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable) {
                                    set.addSuppressed(throwable);
                                }
                            }
                            throw set;
                        }
                        rs.close();
                    }
                    return bl;
                }
            }
            if (expected == null) {
                try (PreparedStatement ps = connection.prepareStatement(this.insertSQL);){
                    boolean set;
                    Long longValue = value instanceof Long ? (Long)value : null;
                    String stringValue = value instanceof String ? (String)value : null;
                    byte[] bytesValue = value instanceof byte[] ? (byte[])value : null;
                    this.setToPreparedStatement(this.insertSQL, ps, Arrays.asList(this.keyCol, this.longCol, this.stringCol, this.bytesCol, this.ttlCol), Arrays.asList(key, longValue, stringValue, bytesValue, this.ttlToStorage(ttl)));
                    try {
                        ps.executeUpdate();
                        set = true;
                    }
                    catch (SQLException e) {
                        if (!this.dialect.isConcurrentUpdateException(e)) {
                            throw e;
                        }
                        set = false;
                    }
                    if (this.logger.isLogEnabled()) {
                        this.logger.log("  -> " + (set ? "SET" : "FAILED"));
                    }
                    Boolean e = set;
                    return e;
                }
            }
            if (value == null) {
                Column col;
                String sql;
                if (expected instanceof Long) {
                    sql = this.deleteIfLongSQL;
                    col = this.longCol;
                } else if (expected instanceof String) {
                    sql = this.deleteIfStringSQL;
                    col = this.stringCol;
                } else {
                    sql = this.deleteIfBytesSQL;
                    col = this.bytesCol;
                }
                try (PreparedStatement ps = connection.prepareStatement(sql);){
                    boolean set;
                    this.setToPreparedStatement(sql, ps, this.keyCol, (Serializable)((Object)key), col, (Serializable)expected);
                    int count = ps.executeUpdate();
                    boolean bl = set = count == 1;
                    if (this.logger.isLogEnabled()) {
                        this.logger.log("  -> " + (set ? "DEL" : "FAILED"));
                    }
                    Boolean e = set;
                    return e;
                }
            }
            Column column = expected instanceof Long ? this.longCol : (expectedCol = expected instanceof String ? this.stringCol : this.bytesCol);
            Column column2 = value instanceof Long ? this.longCol : (valueCol = value instanceof String ? this.stringCol : this.bytesCol);
            if (expectedCol != valueCol) {
                throw new NuxeoException("TODO expected and value have different types");
            }
            String sql = "UPDATE " + this.tableName + " SET " + valueCol.getQuotedName() + " = ?, " + this.ttlColName + " = ? WHERE " + this.keyColName + " = ? AND " + this.dialect.getQuotedNameForExpression(expectedCol) + " = ?";
            try (PreparedStatement ps = connection.prepareStatement(sql);){
                boolean set;
                this.setToPreparedStatement(sql, ps, Arrays.asList(valueCol, this.ttlCol, this.keyCol, expectedCol), Arrays.asList((Serializable)value, this.ttlToStorage(ttl), key, (Serializable)expected));
                int count = ps.executeUpdate();
                boolean bl = set = count == 1;
                if (this.logger.isLogEnabled()) {
                    this.logger.log("  -> " + (set ? "SET" : "FAILED"));
                }
                Boolean bl3 = set;
                return bl3;
            }
        });
    }

    public long addAndGet(String key, long delta) throws NumberFormatException {
        return (Long)this.runWithConnection(connection -> {
            for (int retry = 0; retry < 5; ++retry) {
                block61: {
                    Long currentLong;
                    Object rs;
                    PreparedStatement ps;
                    block58: {
                        String updateReturningSql;
                        boolean useReturnResultSet = false;
                        if (this.dialect instanceof DialectPostgreSQL) {
                            updateReturningSql = this.updateReturningPostgreSQLSql;
                        } else if (this.dialect instanceof DialectOracle) {
                            updateReturningSql = this.updateReturningOracleSql;
                            useReturnResultSet = true;
                        } else {
                            updateReturningSql = this.dialect instanceof DialectSQLServer ? this.updateReturningSQLServerSql : null;
                        }
                        if (updateReturningSql != null) {
                            List<Column> psColumns = Arrays.asList(this.longCol, this.keyCol);
                            List<Serializable> psValues = Arrays.asList(delta, key);
                            ps = connection.prepareStatement(updateReturningSql);
                            try {
                                int count;
                                boolean hasResultSet;
                                this.setToPreparedStatement(updateReturningSql, ps, psColumns, psValues);
                                if (useReturnResultSet) {
                                    this.dialect.registerReturnParameter(ps, 3, this.longCol.getJdbcType());
                                }
                                if (!(hasResultSet = useReturnResultSet ? (count = ps.executeUpdate()) > 0 : true)) break block58;
                                try (ResultSet rs2 = useReturnResultSet ? this.dialect.getReturnResultSet(ps) : ps.executeQuery();){
                                    if (rs2.next()) {
                                        Long longValue = (Long)this.longCol.getFromResultSet(rs2, 1);
                                        if (longValue == null) {
                                            throw new NumberFormatException("Value is not a Long for key: " + key);
                                        }
                                        Long l = longValue;
                                        return l;
                                    }
                                }
                            }
                            finally {
                                if (ps != null) {
                                    ps.close();
                                }
                            }
                        }
                    }
                    connection.setAutoCommit(false);
                    try (PreparedStatement ps2 = connection.prepareStatement(this.getLongSQL);){
                        this.setToPreparedStatement(this.getLongSQL, ps2, this.keyCol, (Serializable)((Object)key));
                        rs = ps2.executeQuery();
                        try {
                            if (rs.next()) {
                                currentLong = (Long)this.longCol.getFromResultSet((ResultSet)rs, 1);
                                if (this.logger.isLogEnabled()) {
                                    this.logger.logResultSet((ResultSet)rs, Arrays.asList(this.longCol));
                                }
                                if (currentLong == null) {
                                    throw new NumberFormatException("Value is not a Long for key: " + key);
                                }
                            } else {
                                currentLong = null;
                            }
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    if (currentLong == null) {
                        block60: {
                            ps2 = connection.prepareStatement(this.insertLongSQL);
                            this.setToPreparedStatement(this.insertLongSQL, ps2, this.keyCol, (Serializable)((Object)key), this.longCol, Long.valueOf(delta));
                            ps2.executeUpdate();
                            rs = delta;
                            if (ps2 == null) break block60;
                            ps2.close();
                        }
                        return rs;
                        {
                            catch (SQLException e2222) {
                                try {
                                    if (!this.dialect.isConcurrentUpdateException(e2222)) {
                                        throw e2222;
                                    }
                                    break block61;
                                }
                                catch (Throwable e2222) {
                                    throw e2222;
                                }
                                finally {
                                    if (ps2 != null) {
                                        ps2.close();
                                    }
                                }
                            }
                        }
                    }
                    Long newLong = currentLong + delta;
                    ps = connection.prepareStatement(this.updateLongSQL);
                    try {
                        this.setToPreparedStatement(this.updateLongSQL, ps, this.longCol, newLong, this.keyCol, (Serializable)((Object)key), this.longCol, currentLong);
                        int count = ps.executeUpdate();
                        if (count == 1) {
                            Long l = newLong;
                            return l;
                        }
                    }
                    finally {
                        connection.commit();
                        connection.setAutoCommit(true);
                    }
                }
                this.sleepBeforeRetry();
            }
            throw new ConcurrentUpdateException("Failed to do atomic addAndGet for key: " + key);
        });
    }

    protected void sleepBeforeRetry() {
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NuxeoException((Throwable)e);
        }
    }

    protected long addAndGetGeneric(String key, long delta) throws NumberFormatException {
        long result;
        Long newValue;
        Object value;
        do {
            if ((value = this.getObject(key)) == null) {
                result = delta;
                continue;
            }
            Long base = this.toLong(value);
            if (base == null) {
                throw new NumberFormatException("Value is not a Long for key: " + key);
            }
            result = base + delta;
        } while (!this.compareAndSet(key, value, newValue = Long.valueOf(result), 0L));
        return result;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.name + ")";
    }

    private /* synthetic */ void lambda$initialize$0(String tbl, Connection connection) throws SQLException {
        this.dialect = Dialect.createDialect(connection, null);
        this.getTable(connection, tbl);
    }
}

