/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.metrics.reporter;

import io.dropwizard.metrics5.MetricAttribute;
import io.dropwizard.metrics5.MetricFilter;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.graphite.Graphite;
import io.dropwizard.metrics5.graphite.GraphiteSender;
import io.dropwizard.metrics5.graphite.GraphiteUDP;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.runtime.metrics.AbstractMetricsReporter;
import org.nuxeo.runtime.metrics.reporter.patch.NuxeoGraphiteReporter;

public class GraphiteReporter
extends AbstractMetricsReporter {
    private static final Logger log = LogManager.getLogger(GraphiteReporter.class);
    protected static final Integer DEFAULT_PORT = 2003;
    protected static final String DEFAULT_PREFIX = "servers.${hostname}.nuxeo";
    protected InetSocketAddress address;
    protected NuxeoGraphiteReporter reporter;
    protected String prefix;

    @Override
    public void init(long pollInterval, Map<String, String> options) {
        super.init(pollInterval, options);
        String host = this.requireOption("host");
        int port = this.getOptionAsInt("port", DEFAULT_PORT);
        this.address = new InetSocketAddress(host, port);
        this.prefix = this.getPrefix();
    }

    @Override
    public void start(MetricRegistry registry, MetricFilter filter, Set<MetricAttribute> deniedExpansions) {
        GraphiteUDP graphite;
        if (this.getOptionAsBoolean("udp", false)) {
            log.warn("Connecting to graphite in UDP {} reporting every {}s with prefix: {}", (Object)this.address, (Object)this.pollInterval, (Object)this.prefix);
            graphite = new GraphiteUDP(this.address);
        } else {
            log.warn("Connecting to graphite {} reporting every {}s with prefix: {}", (Object)this.address, (Object)this.pollInterval, (Object)this.prefix);
            graphite = new Graphite(this.address);
        }
        this.reporter = new NuxeoGraphiteReporter(registry, filter, io.dropwizard.metrics5.graphite.GraphiteReporter.forRegistry((MetricRegistry)registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MICROSECONDS).prefixedWith(this.prefix).filter(filter).disabledMetricAttributes(deniedExpansions).build((GraphiteSender)graphite));
        this.reporter.start(this.getPollInterval(), TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        log.debug("Stop reporting");
        this.reporter.stop();
    }

    protected String getPrefix() {
        this.prefix = this.getOption("prefix", DEFAULT_PREFIX);
        return this.prefix.replace("${hostname}", this.getCurrentHostname());
    }
}

