/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.core;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.web.resources.api.Processor;

@XObject(value="processor")
public class ProcessorDescriptor
implements Processor {
    @XNode(value="@name")
    public String name;
    @XNode(value="@enabled")
    protected Boolean enabled;
    @XNode(value="class")
    Class<?> klass;
    @XNode(value="@order")
    protected int order = 0;
    @XNode(value="@type")
    protected String type;
    @XNode(value="types@append")
    protected Boolean appendTypes;
    @XNodeList(value="types/type", type=ArrayList.class, componentType=String.class)
    protected List<String> types;

    public String getName() {
        return this.name;
    }

    public boolean isEnableSet() {
        return this.enabled != null;
    }

    public boolean isEnabled() {
        return this.enabled == null || Boolean.TRUE.equals(this.enabled);
    }

    public List<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        if (this.type != null) {
            types.add(this.type);
        }
        types.addAll(this.types);
        return types;
    }

    public int getOrder() {
        return this.order;
    }

    public Class<?> getTargetProcessorClass() {
        return this.klass;
    }

    public int compareTo(Processor o) {
        int cmp = this.order - o.getOrder();
        if (cmp == 0) {
            cmp = this.name.compareTo(o.getName());
        }
        return cmp;
    }

    public ProcessorDescriptor clone() {
        ProcessorDescriptor clone = new ProcessorDescriptor();
        clone.name = this.name;
        clone.enabled = this.enabled;
        clone.klass = this.klass;
        clone.order = this.order;
        clone.type = this.type;
        clone.appendTypes = this.appendTypes;
        if (this.types != null) {
            clone.types = new ArrayList<String>(this.types);
        }
        return clone;
    }

    public void merge(ProcessorDescriptor other) {
        if (other == null) {
            return;
        }
        if (other.isEnableSet()) {
            this.enabled = other.enabled;
        }
    }
}

