/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs;

import java.io.Serializable;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.automation.core.util.Paginable;
import org.nuxeo.ecm.automation.core.util.PaginablePageProvider;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

public abstract class PaginableObject<T>
extends DefaultObject {
    protected Long currentPageIndex;
    protected Long offset;
    protected Long pageSize;
    protected String maxResults;

    protected void initialize(Object ... args) {
        super.initialize(args);
        HttpServletRequest request = this.ctx.getRequest();
        this.currentPageIndex = this.extractLongParam(request, "currentPageIndex", 0L);
        String offsetParam = request.getParameter("offset");
        this.offset = offsetParam == null ? null : Long.valueOf(Long.parseLong(offsetParam));
        this.pageSize = this.extractLongParam(request, "pageSize", 50L);
        this.maxResults = request.getParameter("maxResults");
    }

    protected abstract PageProviderDefinition getPageProviderDefinition();

    protected Object[] getParams() {
        return new Object[0];
    }

    protected DocumentModel getSearchDocument() {
        return null;
    }

    public Paginable<T> getPaginableEntries() {
        PageProviderDefinition ppDefinition = this.getPageProviderDefinition();
        if (ppDefinition == null) {
            throw new NuxeoException("Page provider given not found");
        }
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.ctx.getCoreSession());
        return this.getPaginableEntries(pps.getPageProvider("", ppDefinition, this.getSearchDocument(), null, this.pageSize, this.currentPageIndex, this.offset, props, null, null, this.getParams()));
    }

    protected Paginable<T> getPaginableEntries(PageProvider<T> pageProvider) {
        return new PaginablePageProvider(pageProvider);
    }

    protected Long extractLongParam(HttpServletRequest request, String paramName, Long defaultValue) {
        String strParam = request.getParameter(paramName);
        return strParam == null ? defaultValue : Long.parseLong(strParam);
    }
}

