/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.CoreService;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DetachedAdapter;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelFactory;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.LifeCycleException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.LockException;
import org.nuxeo.ecm.core.api.LockHelper;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.impl.DocumentModelChildrenIterator;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.api.impl.VersionModelImpl;
import org.nuxeo.ecm.core.api.query.QueryFilter;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.UserEntry;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.api.security.impl.UserEntryImpl;
import org.nuxeo.ecm.core.api.trash.TrashService;
import org.nuxeo.ecm.core.api.validation.DocumentValidationException;
import org.nuxeo.ecm.core.api.validation.DocumentValidationReport;
import org.nuxeo.ecm.core.api.validation.DocumentValidationService;
import org.nuxeo.ecm.core.api.versioning.VersioningService;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.filter.CharacterFilteringService;
import org.nuxeo.ecm.core.lifecycle.LifeCycleService;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.PathComparator;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.security.LockSecurityPolicy;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.services.config.ConfigurationService;

public abstract class AbstractSession
implements CoreSession,
Serializable {
    private static final Logger log = LogManager.getLogger(CoreSession.class);
    private static final long serialVersionUID = 1L;
    private static final Comparator<? super Document> pathComparator = new PathComparator();
    public static final String DEFAULT_MAX_RESULTS = "1000";
    public static final String MAX_RESULTS_PROPERTY = "org.nuxeo.ecm.core.max.results";
    public static final String LIMIT_RESULTS_PROPERTY = "org.nuxeo.ecm.core.limit.results";
    @Deprecated
    public static final String TRASH_KEEP_CHECKED_IN_PROPERTY = "org.nuxeo.trash.keepCheckedIn";
    public static final String DISABLED_ISLATESTVERSION_PROPERTY = "org.nuxeo.core.isLatestVersion.disabled";
    public static final String BINARY_TEXT_SYS_PROP = "fulltextBinary";
    private Boolean limitedResults;
    private Long maxResults;
    protected static final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected static final Map<String, Counter> CREATE_DOC_COUNT = new ConcurrentHashMap<String, Counter>();
    protected static final Map<String, Counter> DELETE_DOC_COUNT = new ConcurrentHashMap<String, Counter>();
    protected static final Map<String, Counter> UPDATE_DOC_COUNT = new ConcurrentHashMap<String, Counter>();
    protected Counter createDocumentCount;
    protected Counter deleteDocumentCount;
    protected Counter updateDocumentCount;
    protected static final PathRef EMPTY_PATH = new PathRef("");

    protected void createDocumentCountInc() {
        if (this.createDocumentCount == null) {
            this.createDocumentCount = CREATE_DOC_COUNT.computeIfAbsent(this.getRepositoryName(), repositoryName -> registry.counter(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "documents", "create"}).tagged(new String[]{"repository", repositoryName})));
        }
        this.createDocumentCount.inc();
    }

    protected void deleteDocumentCountInc() {
        if (this.deleteDocumentCount == null) {
            this.deleteDocumentCount = DELETE_DOC_COUNT.computeIfAbsent(this.getRepositoryName(), repositoryName -> registry.counter(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "documents", "delete"}).tagged(new String[]{"repository", repositoryName})));
        }
        this.deleteDocumentCount.inc();
    }

    protected void updateDocumentCountInc() {
        if (this.updateDocumentCount == null) {
            this.updateDocumentCount = UPDATE_DOC_COUNT.computeIfAbsent(this.getRepositoryName(), repositoryName -> registry.counter(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "documents", "update"}).tagged(new String[]{"repository", repositoryName})));
        }
        this.updateDocumentCount.inc();
    }

    protected SecurityService getSecurityService() {
        return (SecurityService)((Object)Framework.getService(SecurityService.class));
    }

    protected VersioningService getVersioningService() {
        return (VersioningService)Framework.getService(VersioningService.class);
    }

    protected DocumentValidationService getValidationService() {
        return (DocumentValidationService)Framework.getService(DocumentValidationService.class);
    }

    public abstract Session getSession();

    public DocumentType getDocumentType(String type) {
        return ((SchemaManager)Framework.getService(SchemaManager.class)).getDocumentType(type);
    }

    protected final void checkPermission(Document doc, String permission) throws DocumentSecurityException {
        if (this.isAdministrator()) {
            return;
        }
        if (!this.hasPermission(doc, permission)) {
            log.debug("Permission '{}' is not granted to '{}' on document {} ({} - {})", (Object)permission, (Object)this.getPrincipal().getName(), (Object)doc.getPath(), (Object)doc.getUUID(), (Object)doc.getType().getName());
            throw new DocumentSecurityException("Privilege '" + permission + "' is not granted to '" + this.getPrincipal().getName() + "'");
        }
    }

    protected Map<String, Serializable> getContextMapEventInfo(DocumentModel doc) {
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        if (doc != null) {
            options.putAll(doc.getContextData());
        }
        return options;
    }

    public DocumentEventContext newEventContext(DocumentModel source) {
        DocumentEventContext ctx = new DocumentEventContext((CoreSession)this, this.getPrincipal(), source);
        ctx.setProperty("repositoryName", (Serializable)((Object)this.getRepositoryName()));
        return ctx;
    }

    protected void notifyEvent(String eventId, DocumentModel source, Map<String, Serializable> options, String category, String comment, boolean withLifeCycle, boolean inline) {
        DocumentEventContext ctx = new DocumentEventContext((CoreSession)this, this.getPrincipal(), source);
        if (options != null) {
            ctx.setProperties(options);
        }
        ctx.setProperty("repositoryName", (Serializable)((Object)this.getRepositoryName()));
        if (source != null && withLifeCycle) {
            String currentLifeCycleState = source.getCurrentLifeCycleState();
            ctx.setProperty("documentLifeCycle", (Serializable)((Object)currentLifeCycleState));
        }
        if (comment != null) {
            ctx.setProperty("comment", (Serializable)((Object)comment));
        }
        ctx.setProperty("category", (Serializable)((Object)(category == null ? "eventDocumentCategory" : category)));
        Event event = ctx.newEvent(eventId);
        if ("sessionSaved".equals(eventId)) {
            event.setIsCommitEvent(true);
        }
        if (inline) {
            event.setInline(true);
        }
        ((EventService)Framework.getService(EventService.class)).fireEvent(event);
    }

    protected void notifyVersionChange(DocumentModel oldDocument, DocumentModel newDocument, Map<String, Serializable> options) {
        HashMap<String, Serializable> info = new HashMap<String, Serializable>();
        if (options != null) {
            info.putAll(options);
        }
        info.put("newDoc", (Serializable)newDocument);
        info.put("oldDoc", (Serializable)oldDocument);
        this.notifyEvent("versioningChangeCoreEvent", newDocument, info, "clientCodeNotificationCategory", null, false, false);
    }

    public boolean hasPermission(NuxeoPrincipal principal, DocumentRef docRef, String permission) {
        Document doc = this.resolveReference(docRef);
        return this.hasPermission(principal, doc, permission);
    }

    protected final boolean hasPermission(NuxeoPrincipal principal, Document doc, String permission) {
        return this.getSecurityService().checkPermission(doc, principal, permission);
    }

    public boolean hasPermission(DocumentRef docRef, String permission) {
        Document doc = this.resolveReference(docRef);
        return this.hasPermission(doc, permission);
    }

    public Collection<String> filterGrantedPermissions(NuxeoPrincipal principal, DocumentRef docRef, Collection<String> permissions) {
        Document doc = this.resolveReference(docRef);
        return this.getSecurityService().filterGrantedPermissions(doc, principal, permissions);
    }

    protected final boolean hasPermission(Document doc, String permission) {
        return this.getSecurityService().checkPermission(doc, this.getPrincipal(), permission);
    }

    protected Document resolveReference(DocumentRef docRef) {
        if (docRef == null) {
            throw new IllegalArgumentException("null docRref");
        }
        Object ref = docRef.reference();
        if (ref == null) {
            throw new IllegalArgumentException("null reference");
        }
        int type = docRef.type();
        switch (type) {
            case 1: {
                return this.getSession().getDocumentByUUID((String)ref);
            }
            case 2: {
                return this.getSession().resolvePath((String)ref);
            }
            case 3: {
                return this.getSession().getDocumentByUUID(((DocumentModel)ref).getId());
            }
        }
        throw new IllegalArgumentException("Invalid type: " + type);
    }

    protected Document resolveParentReference(DocumentRef docRef) {
        if (docRef != null && docRef.type() == 2 && docRef.reference() != null) {
            String docPath = (String)docRef.reference();
            if ("/".equals(docPath)) {
                return null;
            }
            String parentPath = docPath.substring(0, docPath.lastIndexOf(47));
            if (parentPath.isEmpty()) {
                parentPath = "/";
            }
            return this.resolveReference((DocumentRef)new PathRef(parentPath));
        }
        return this.resolveReference(docRef).getParent();
    }

    protected DocumentModel readModel(Document doc) {
        return DocumentModelFactory.createDocumentModel(doc, this);
    }

    protected DocumentModel readModel(Document doc, DocumentModel docModel) {
        DocumentModel newModel = this.readModel(doc);
        newModel.copyContextData(docModel);
        return newModel;
    }

    protected DocumentModel writeModel(Document doc, DocumentModel docModel) {
        return DocumentModelFactory.writeDocumentModel(docModel, doc);
    }

    @Deprecated
    public DocumentModel copy(DocumentRef src, DocumentRef dst, String name, boolean resetLifeCycle) {
        if (resetLifeCycle) {
            return this.copy(src, dst, name, CoreSession.CopyOption.RESET_LIFE_CYCLE);
        }
        return this.copy(src, dst, name, new CoreSession.CopyOption[0]);
    }

    public DocumentModel copy(DocumentRef src, DocumentRef dst, String name, CoreSession.CopyOption ... copyOptions) {
        Document dstDoc = this.resolveReference(dst);
        this.checkPermission(dstDoc, "AddChildren");
        Document srcDoc = this.resolveReference(src);
        if (name == null) {
            name = srcDoc.getName();
        } else {
            PathRef.checkName((String)name);
        }
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        options.put("sourceRef", (Serializable)src);
        options.put("destinationRef", (Serializable)dst);
        options.put("destinationPath", (Serializable)((Object)dstDoc.getPath()));
        options.put("destinationName", (Serializable)((Object)name));
        options.put("destinationExists", Boolean.valueOf(dstDoc.hasChild(name)));
        options.put("resetLifeCycle", Boolean.valueOf(CoreSession.CopyOption.isResetLifeCycle((CoreSession.CopyOption[])copyOptions)));
        options.put("resetCreator", Boolean.valueOf(CoreSession.CopyOption.isResetCreator((CoreSession.CopyOption[])copyOptions)));
        DocumentModel srcDocModel = this.readModel(srcDoc);
        this.notifyEvent("aboutToCopy", srcDocModel, options, null, null, true, true);
        name = (String)options.get("destinationName");
        Document doc = this.getSession().copy(srcDoc, dstDoc, name);
        DocumentModel docModel = this.readModel(doc);
        String comment = srcDoc.getRepositoryName() + ":" + src.toString();
        this.notifyEvent("documentCreatedByCopy", docModel, options, null, comment, true, false);
        docModel = this.writeModel(doc, docModel);
        comment = doc.getRepositoryName() + ":" + docModel.getRef().toString();
        this.notifyEvent("documentDuplicated", srcDocModel, options, null, comment, true, false);
        return docModel;
    }

    @Deprecated
    public List<DocumentModel> copy(List<DocumentRef> src, DocumentRef dst, boolean resetLifeCycle) {
        if (resetLifeCycle) {
            return this.copy(src, dst, CoreSession.CopyOption.RESET_LIFE_CYCLE);
        }
        return this.copy(src, dst, new CoreSession.CopyOption[0]);
    }

    public List<DocumentModel> copy(List<DocumentRef> src, DocumentRef dst, CoreSession.CopyOption ... opts) {
        return src.stream().map(ref -> this.copy((DocumentRef)ref, dst, null, opts)).collect(Collectors.toList());
    }

    @Deprecated
    public DocumentModel copyProxyAsDocument(DocumentRef src, DocumentRef dst, String name, boolean resetLifeCycle) {
        if (resetLifeCycle) {
            return this.copyProxyAsDocument(src, dst, name, CoreSession.CopyOption.RESET_LIFE_CYCLE);
        }
        return this.copyProxyAsDocument(src, dst, name, new CoreSession.CopyOption[0]);
    }

    public DocumentModel copyProxyAsDocument(DocumentRef src, DocumentRef dst, String name, CoreSession.CopyOption ... copyOptions) {
        Document srcDoc = this.resolveReference(src);
        if (!srcDoc.isProxy()) {
            return this.copy(src, dst, name, new CoreSession.CopyOption[0]);
        }
        Document dstDoc = this.resolveReference(dst);
        this.checkPermission(dstDoc, "Write");
        DocumentModel srcDocModel = this.readModel(srcDoc);
        String docName = name != null ? name : srcDocModel.getName();
        DocumentModel docModel = this.createDocumentModel(dstDoc.getPath(), docName, srcDocModel.getType());
        docModel.copyContent(srcDocModel);
        this.notifyEvent("aboutToCopy", srcDocModel, null, null, null, true, true);
        docModel = this.createDocument(docModel);
        Document doc = this.resolveReference(docModel.getRef());
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        options.put("resetLifeCycle", Boolean.valueOf(CoreSession.CopyOption.isResetLifeCycle((CoreSession.CopyOption[])copyOptions)));
        options.put("resetCreator", Boolean.valueOf(CoreSession.CopyOption.isResetCreator((CoreSession.CopyOption[])copyOptions)));
        String comment = srcDoc.getRepositoryName() + ":" + src.toString();
        this.notifyEvent("documentCreatedByCopy", docModel, options, null, comment, true, false);
        comment = doc.getRepositoryName() + ":" + docModel.getRef().toString();
        this.notifyEvent("documentDuplicated", srcDocModel, options, null, comment, true, false);
        return docModel;
    }

    @Deprecated
    public List<DocumentModel> copyProxyAsDocument(List<DocumentRef> src, DocumentRef dst, boolean resetLifeCycle) {
        if (resetLifeCycle) {
            return this.copyProxyAsDocument(src, dst, CoreSession.CopyOption.RESET_LIFE_CYCLE);
        }
        return this.copyProxyAsDocument(src, dst, new CoreSession.CopyOption[0]);
    }

    public List<DocumentModel> copyProxyAsDocument(List<DocumentRef> src, DocumentRef dst, CoreSession.CopyOption ... opts) {
        return src.stream().map(ref -> this.copyProxyAsDocument((DocumentRef)ref, dst, null, opts)).collect(Collectors.toList());
    }

    public DocumentModel move(DocumentRef src, DocumentRef dst, String name) {
        Document dstDoc;
        Document srcDoc = this.resolveReference(src);
        if (dst == null) {
            dstDoc = srcDoc.getParent();
            this.checkPermission(dstDoc, "WriteProperties");
        } else {
            dstDoc = this.resolveReference(dst);
            this.checkPermission(dstDoc, "AddChildren");
            this.checkPermission(srcDoc.getParent(), "RemoveChildren");
            this.checkPermission(srcDoc, "Remove");
        }
        DocumentModel srcDocModel = this.readModel(srcDoc);
        String originalName = srcDocModel.getName();
        if (name == null) {
            name = srcDocModel.getName();
        } else {
            PathRef.checkName((String)name);
        }
        Map<String, Serializable> options = this.getContextMapEventInfo(srcDocModel);
        options.put("sourceRef", (Serializable)src);
        options.put("destinationRef", (Serializable)dst);
        options.put("destinationPath", (Serializable)((Object)dstDoc.getPath()));
        options.put("destinationName", (Serializable)((Object)name));
        options.put("destinationExists", Boolean.valueOf(dstDoc.hasChild(name)));
        this.notifyEvent("aboutToMove", srcDocModel, options, null, null, true, true);
        name = (String)((Object)options.get("destinationName"));
        if (!originalName.equals(name)) {
            options.put("originalName", (Serializable)((Object)originalName));
        }
        String comment = srcDoc.getRepositoryName() + ":" + srcDoc.getParent().getUUID();
        Document doc = this.getSession().move(srcDoc, dstDoc, name);
        DocumentModel docModel = this.readModel(doc);
        options.put("parentPath", (Serializable)srcDocModel.getParentRef());
        this.notifyEvent("documentMoved", docModel, options, null, comment, true, false);
        return docModel;
    }

    public void move(List<DocumentRef> src, DocumentRef dst) {
        for (DocumentRef ref : src) {
            this.move(ref, dst, null);
        }
    }

    public ACP getACP(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "ReadSecurity");
        return this.getSession().getMergedACP(doc);
    }

    public void setACP(DocumentRef docRef, ACP newAcp, boolean overwrite) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "WriteSecurity");
        this.setACP(doc, newAcp, overwrite, null);
    }

    protected void setACP(Document doc, ACP newAcp, boolean overwrite, Map<String, Serializable> options) {
        ACP oldAcp;
        DocumentModel docModel = this.readModel(doc);
        if (options == null) {
            options = new HashMap<String, Serializable>();
        }
        if ((oldAcp = docModel.getACP()) != null) {
            options.put("oldACP", (Serializable)oldAcp.clone());
        }
        options.put("newACP", (Serializable)newAcp);
        this.notifyEvent("beforeDocumentSecurityModification", docModel, options, null, null, true, true);
        this.getSession().setACP(doc, newAcp, overwrite);
        docModel = this.readModel(doc);
        options.put("newACP", (Serializable)newAcp.clone());
        this.notifyEvent("documentSecurityUpdated", docModel, options, null, null, true, false);
    }

    public void replaceACE(DocumentRef docRef, String aclName, ACE oldACE, ACE newACE) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "WriteSecurity");
        ACP acp = this.getACP(docRef);
        if (acp.replaceACE(aclName, oldACE, newACE)) {
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            options.put("oldACE", (Serializable)oldACE);
            options.put("newACE", (Serializable)newACE);
            options.put("changedACLName", (Serializable)((Object)aclName));
            this.setACP(doc, acp, true, options);
        }
    }

    public void updateReadACLs(Collection<String> docIds) {
        this.getSession().updateReadACLs(docIds);
    }

    public boolean isNegativeAclAllowed() {
        return this.getSession().isNegativeAclAllowed();
    }

    public void cancel() {
    }

    private DocumentModel createDocumentModelFromTypeName(String typeName, Map<String, Serializable> options) {
        return this.createDocumentModelFromParentAndType(null, typeName, options);
    }

    private DocumentModel createDocumentModelFromParentAndType(DocumentRef parentRef, String typeName, Map<String, Serializable> options) {
        DocumentModelImpl docModel = DocumentModelFactory.createDocumentModel(typeName, parentRef, this);
        if (options == null) {
            options = new HashMap<String, Serializable>();
        } else if (options.containsKey("parentPath") && options.containsKey("destinationName")) {
            docModel.setPathInfo((String)((Object)options.get("parentPath")), (String)((Object)options.get("destinationName")));
        }
        this.notifyEvent("emptyDocumentModelCreated", (DocumentModel)docModel, options, null, null, false, true);
        return docModel;
    }

    public DocumentModel createDocumentModel(String typeName) {
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        return this.createDocumentModelFromTypeName(typeName, options);
    }

    public DocumentModel createDocumentModel(String parentPath, String name, String typeName) {
        if (parentPath == null && name == null) {
            return this.createDocumentModel(typeName);
        }
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        options.put("parentPath", (Serializable)((Object)parentPath));
        options.put("documentModelId", (Serializable)((Object)name));
        options.put("destinationName", (Serializable)((Object)name));
        return this.createDocumentModelFromTypeName(typeName, options);
    }

    public DocumentModel createDocumentModel(String typeName, Map<String, Object> options) {
        HashMap<String, Serializable> serializableOptions = new HashMap<String, Serializable>();
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            serializableOptions.put(entry.getKey(), (Serializable)entry.getValue());
        }
        return this.createDocumentModelFromTypeName(typeName, serializableOptions);
    }

    public DocumentModel createDocument(DocumentModel docModel) {
        DocumentValidationReport report;
        CharacterFilteringService charFilteringService = (CharacterFilteringService)Framework.getService(CharacterFilteringService.class);
        charFilteringService.filter(docModel);
        if (!docModel.isAttached()) {
            docModel.attach((CoreSession)this);
        }
        String typeName = docModel.getType();
        DocumentRef parentRef = docModel.getParentRef();
        if (typeName == null) {
            throw new NullPointerException("null typeName");
        }
        if (parentRef == null && !this.isAdministrator()) {
            throw new NuxeoException("Only Administrators can create placeless documents");
        }
        String childName = docModel.getName();
        Map<String, Serializable> options = this.getContextMapEventInfo(docModel);
        Document parent = this.fillCreateOptions(parentRef, childName, options);
        String initialLifecycleState = null;
        Serializable lifecycleStateInfo = docModel.getContextData("initialLifecycleState");
        if (lifecycleStateInfo instanceof String) {
            initialLifecycleState = (String)((Object)lifecycleStateInfo);
        }
        this.notifyEvent("aboutToCreate", docModel, options, null, null, false, true);
        if (this.getValidationService().isActivated("createDocument", options) && (report = this.getValidationService().validate(docModel, false)).hasError()) {
            throw new DocumentValidationException(report);
        }
        childName = (String)((Object)options.get("destinationName"));
        Document doc = parent.addChild(childName, typeName);
        for (String facetName : docModel.getFacets()) {
            if (doc.getAllFacets().contains(facetName) || "Immutable".equals(facetName)) continue;
            doc.addFacet(facetName);
        }
        this.getLifeCycleService().initialize(doc, initialLifecycleState);
        docModel = this.writeModel(doc, docModel);
        if (!Boolean.TRUE.equals(docModel.getContextData("SKIP_VERSIONING"))) {
            this.getVersioningService().doPostCreate(doc, options);
        }
        docModel = this.readModel(doc, docModel);
        this.getVersioningService().doAutomaticVersioning(null, docModel, false);
        this.notifyEvent("documentCreated", docModel, options, null, null, true, false);
        docModel = this.writeModel(doc, docModel);
        this.createDocumentCountInc();
        return docModel;
    }

    private LifeCycleService getLifeCycleService() {
        return (LifeCycleService)Framework.getService(LifeCycleService.class);
    }

    protected Document fillCreateOptions(DocumentRef parentRef, String childName, Map<String, Serializable> options) throws DocumentSecurityException {
        Document parent;
        if (parentRef == null || EMPTY_PATH.equals((Object)parentRef)) {
            parent = this.getSession().getNullDocument();
            options.put("destinationRef", null);
            options.put("destinationPath", null);
            options.put("destinationName", (Serializable)((Object)childName));
            options.put("destinationExists", Boolean.valueOf(false));
        } else {
            parent = this.resolveReference(parentRef);
            this.checkPermission(parent, "AddChildren");
            options.put("destinationRef", (Serializable)parentRef);
            options.put("destinationPath", (Serializable)((Object)parent.getPath()));
            options.put("destinationName", (Serializable)((Object)childName));
            if (Boolean.TRUE.equals(options.get("skipDestinationCheck"))) {
                options.put("destinationExists", Boolean.valueOf(false));
            } else {
                options.put("destinationExists", Boolean.valueOf(parent.hasChild(childName)));
            }
        }
        return parent;
    }

    public void importDocuments(List<DocumentModel> docModels) {
        docModels.forEach(this::importDocument);
    }

    protected void importDocument(DocumentModel docModel) {
        DocumentValidationReport report;
        if (!this.isAdministrator()) {
            throw new DocumentSecurityException("Only Administrator can import");
        }
        String name = docModel.getName();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Invalid empty name");
        }
        String typeName = docModel.getType();
        if (typeName == null || typeName.length() == 0) {
            throw new IllegalArgumentException("Invalid empty type");
        }
        String id = docModel.getId();
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("Invalid empty id");
        }
        DocumentRef parentRef = docModel.getParentRef();
        Map<String, Serializable> props = this.getContextMapEventInfo(docModel);
        if (parentRef != null && EMPTY_PATH.equals((Object)parentRef)) {
            parentRef = null;
        }
        Document parent = this.fillCreateOptions(parentRef, name, props);
        this.notifyEvent("aboutToImport", docModel, props, null, null, false, true);
        name = (String)((Object)props.get("destinationName"));
        if (this.getValidationService().isActivated("importDocument", props) && (report = this.getValidationService().validate(docModel, true)).hasError()) {
            throw new DocumentValidationException(report);
        }
        Document doc = this.getSession().importDocument(id, parentRef == null ? null : parent, name, typeName, props);
        docModel = typeName.equals("ecm:proxy") ? this.readModel(doc) : this.writeModel(doc, docModel);
        this.notifyEvent("documentImported", docModel, null, null, null, true, false);
    }

    public DocumentModel[] createDocument(DocumentModel[] docModels) {
        DocumentModel[] models = new DocumentModel[docModels.length];
        int i = 0;
        for (DocumentModel docModel : docModels) {
            models[i++] = this.createDocument(docModel);
        }
        return models;
    }

    public boolean exists(DocumentRef docRef) {
        try {
            Document doc = this.resolveReference(docRef);
            return this.hasPermission(doc, "Browse");
        }
        catch (DocumentNotFoundException e) {
            return false;
        }
    }

    public DocumentModel getChild(DocumentRef parent, String name) {
        Document doc = this.resolveReference(parent);
        this.checkPermission(doc, "ReadChildren");
        Document child = doc.getChild(name);
        this.checkPermission(child, "Read");
        return this.readModel(child);
    }

    public boolean hasChild(DocumentRef parent, String name) {
        Document doc = this.resolveReference(parent);
        this.checkPermission(doc, "ReadChildren");
        return doc.hasChild(name);
    }

    public DocumentModelList getChildren(DocumentRef parent) {
        return this.getChildren(parent, null, "Read", null, null);
    }

    public DocumentModelList getChildren(DocumentRef parent, String type) {
        return this.getChildren(parent, type, "Read", null, null);
    }

    public DocumentModelList getChildren(DocumentRef parent, String type, String perm) {
        return this.getChildren(parent, type, perm, null, null);
    }

    public DocumentModelList getChildren(DocumentRef parent, String type, Filter filter, Sorter sorter) {
        return this.getChildren(parent, type, null, filter, sorter);
    }

    public DocumentModelList getChildren(DocumentRef parent, String type, String perm, Filter filter, Sorter sorter) {
        if (perm == null) {
            perm = "Read";
        }
        Document doc = this.resolveReference(parent);
        this.checkPermission(doc, "ReadChildren");
        DocumentModelListImpl docs = new DocumentModelListImpl();
        for (Document child : doc.getChildren()) {
            if (!this.hasPermission(child, perm) || child.getType() == null || type != null && !type.equals(child.getType().getName())) continue;
            DocumentModel childModel = this.readModel(child);
            if (filter != null && !filter.accept(childModel)) continue;
            docs.add((Object)childModel);
        }
        if (sorter != null) {
            docs.sort((Comparator)sorter);
        }
        return docs;
    }

    public List<DocumentRef> getChildrenRefs(DocumentRef parentRef, String perm) {
        if (perm != null) {
            throw new NullPointerException("perm != null not implemented");
        }
        Document parent = this.resolveReference(parentRef);
        this.checkPermission(parent, "ReadChildren");
        List ids = parent.getChildrenIds();
        ArrayList<DocumentRef> refs = new ArrayList<DocumentRef>(ids.size());
        for (String id : ids) {
            refs.add((DocumentRef)new IdRef(id));
        }
        return refs;
    }

    public DocumentModelIterator getChildrenIterator(DocumentRef parent) {
        return this.getChildrenIterator(parent, null, null, null);
    }

    public DocumentModelIterator getChildrenIterator(DocumentRef parent, String type) {
        return this.getChildrenIterator(parent, type, null, null);
    }

    public DocumentModelIterator getChildrenIterator(DocumentRef parent, String type, String perm, Filter filter) {
        return new DocumentModelChildrenIterator((CoreSession)this, parent, type, filter);
    }

    public DocumentModel getDocument(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "Read");
        return this.readModel(doc);
    }

    public DocumentModelList getDocuments(DocumentRef[] docRefs) {
        ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>(docRefs.length);
        for (DocumentRef docRef : docRefs) {
            Document doc;
            try {
                doc = this.resolveReference(docRef);
                this.checkPermission(doc, "Read");
            }
            catch (DocumentSecurityException e) {
                continue;
            }
            docs.add(this.readModel(doc));
        }
        return new DocumentModelListImpl(docs);
    }

    public DocumentModelList getFiles(DocumentRef parent) {
        Document doc = this.resolveReference(parent);
        this.checkPermission(doc, "ReadChildren");
        DocumentModelListImpl docs = new DocumentModelListImpl();
        for (Document child : doc.getChildren()) {
            if (child.isFolder() || !this.hasPermission(child, "Read")) continue;
            docs.add((Object)this.readModel(child));
        }
        return docs;
    }

    public DocumentModelList getFiles(DocumentRef parent, Filter filter, Sorter sorter) {
        Document doc = this.resolveReference(parent);
        this.checkPermission(doc, "ReadChildren");
        DocumentModelListImpl docs = new DocumentModelListImpl();
        for (Document child : doc.getChildren()) {
            if (child.isFolder() || !this.hasPermission(child, "Read")) continue;
            DocumentModel docModel = this.readModel(doc);
            if (filter != null && !filter.accept(docModel)) continue;
            docs.add((Object)this.readModel(child));
        }
        if (sorter != null) {
            docs.sort((Comparator)sorter);
        }
        return docs;
    }

    public DocumentModelList getFolders(DocumentRef parent) {
        Document doc = this.resolveReference(parent);
        this.checkPermission(doc, "ReadChildren");
        DocumentModelListImpl docs = new DocumentModelListImpl();
        for (Document child : doc.getChildren()) {
            if (!child.isFolder() || !this.hasPermission(child, "Read")) continue;
            docs.add((Object)this.readModel(child));
        }
        return docs;
    }

    public DocumentModelList getFolders(DocumentRef parent, Filter filter, Sorter sorter) {
        Document doc = this.resolveReference(parent);
        this.checkPermission(doc, "ReadChildren");
        DocumentModelListImpl docs = new DocumentModelListImpl();
        for (Document child : doc.getChildren()) {
            if (!child.isFolder() || !this.hasPermission(child, "Read")) continue;
            DocumentModel childModel = this.readModel(child);
            if (filter != null && !filter.accept(childModel)) continue;
            docs.add((Object)childModel);
        }
        if (sorter != null) {
            docs.sort((Comparator)sorter);
        }
        return docs;
    }

    public DocumentRef getParentDocumentRef(DocumentRef docRef) {
        Document parentDoc = this.resolveParentReference(docRef);
        return parentDoc != null ? new IdRef(parentDoc.getUUID()) : null;
    }

    public DocumentModel getParentDocument(DocumentRef docRef) {
        Document parentDoc = this.resolveParentReference(docRef);
        if (parentDoc == null) {
            return null;
        }
        if (!this.hasPermission(parentDoc, "Read")) {
            throw new DocumentSecurityException("Privilege READ is not granted to " + this.getPrincipal().getName());
        }
        return this.readModel(parentDoc);
    }

    public List<DocumentModel> getParentDocuments(DocumentRef docRef) {
        if (null == docRef) {
            throw new IllegalArgumentException("null docRef");
        }
        ArrayList<DocumentModel> docsList = new ArrayList<DocumentModel>();
        for (Document doc = this.resolveReference(docRef); doc != null && !"/".equals(doc.getPath()) && this.hasPermission(doc, "Read"); doc = doc.getParent()) {
            docsList.add(this.readModel(doc));
        }
        Collections.reverse(docsList);
        return docsList;
    }

    public DocumentModel getRootDocument() {
        return this.readModel(this.getSession().getRootDocument());
    }

    public boolean hasChildren(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "Browse");
        return doc.hasChildren();
    }

    public DocumentModelList query(String query) {
        return this.query(query, null, 0L, 0L, false);
    }

    public DocumentModelList query(String query, int max) {
        return this.query(query, null, (long)max, 0L, false);
    }

    public DocumentModelList query(String query, Filter filter) {
        return this.query(query, filter, 0L, 0L, false);
    }

    public DocumentModelList query(String query, Filter filter, int max) {
        return this.query(query, filter, (long)max, 0L, false);
    }

    public DocumentModelList query(String query, Filter filter, long limit, long offset, boolean countTotal) {
        return this.query(query, "NXQL", filter, limit, offset, countTotal);
    }

    public DocumentModelList query(String query, String queryType, Filter filter, long limit, long offset, boolean countTotal) {
        long countUpTo = this.computeCountUpTo(countTotal);
        return this.query(query, queryType, filter, limit, offset, countUpTo);
    }

    protected long computeCountUpTo(boolean countTotal) {
        long countUpTo = !countTotal ? 0L : (this.isLimitedResults() ? this.getMaxResults() : -1L);
        return countUpTo;
    }

    protected long getMaxResults() {
        if (this.maxResults == null) {
            this.maxResults = Long.valueOf(Framework.getProperty((String)MAX_RESULTS_PROPERTY, (String)DEFAULT_MAX_RESULTS));
        }
        return this.maxResults;
    }

    protected boolean isLimitedResults() {
        if (this.limitedResults == null) {
            this.limitedResults = Boolean.valueOf(Framework.getProperty((String)LIMIT_RESULTS_PROPERTY));
        }
        return this.limitedResults;
    }

    protected void setMaxResults(long maxResults) {
        this.maxResults = maxResults;
    }

    protected void setLimitedResults(boolean limitedResults) {
        this.limitedResults = limitedResults;
    }

    public DocumentModelList query(String query, Filter filter, long limit, long offset, long countUpTo) {
        return this.query(query, "NXQL", filter, limit, offset, countUpTo);
    }

    public DocumentModelList query(String query, String queryType, Filter filter, long limit, long offset, long countUpTo) {
        SecurityService securityService = this.getSecurityService();
        NuxeoPrincipal principal = this.getPrincipal();
        try {
            String permission = "Browse";
            String repoName = this.getRepositoryName();
            boolean postFilterPolicies = !securityService.arePoliciesExpressibleInQuery(repoName);
            boolean postFilterFilter = filter != null && !(filter instanceof FacetFilter);
            boolean postFilter = postFilterPolicies || postFilterFilter;
            String[] principals = this.getPrincipalsToCheck();
            String[] permissions = securityService.getPermissionsToCheck(permission);
            Collection<SQLQuery.Transformer> transformers = this.getPoliciesQueryTransformers(queryType);
            org.nuxeo.ecm.core.query.QueryFilter queryFilter = new org.nuxeo.ecm.core.query.QueryFilter(principal, principals, permissions, filter instanceof FacetFilter ? (FacetFilter)filter : null, transformers, postFilter ? 0L : limit, postFilter ? 0L : offset);
            PartialList pl = this.getSession().query(query, queryType, (QueryFilter)queryFilter, postFilter ? -1L : countUpTo);
            DocumentModelListImpl dms = new DocumentModelListImpl(pl.size());
            dms.setTotalSize(pl.totalSize());
            for (Document doc : pl) {
                dms.add((Object)this.readModel(doc));
            }
            if (!postFilter) {
                return dms;
            }
            long start = limit == 0L || offset < 0L ? 0L : offset;
            long stop = start + (limit == 0L ? (long)dms.size() : limit);
            int n = 0;
            DocumentModelListImpl docs = new DocumentModelListImpl();
            for (DocumentModel model : dms) {
                if (postFilterPolicies && !this.hasPermission(model.getRef(), permission) || postFilterFilter && !filter.accept(model)) continue;
                if ((long)n < start) {
                    ++n;
                    continue;
                }
                if ((long)n >= stop) {
                    if (countUpTo == 0L) break;
                    ++n;
                    continue;
                }
                ++n;
                docs.add((Object)model);
            }
            if (countUpTo != 0L) {
                docs.setTotalSize((long)n);
            }
            return docs;
        }
        catch (QueryParseException e) {
            e.addInfo("Failed to execute query: " + query);
            throw e;
        }
    }

    public IterableQueryResult queryAndFetch(String query, String queryType, Object ... params) {
        return this.queryAndFetch(query, queryType, false, params);
    }

    public IterableQueryResult queryAndFetch(String query, String queryType, boolean distinctDocuments, Object ... params) {
        try {
            SecurityService securityService = this.getSecurityService();
            NuxeoPrincipal principal = this.getPrincipal();
            String[] principals = this.getPrincipalsToCheck();
            String[] permissions = securityService.getPermissionsToCheck("Browse");
            Collection<SQLQuery.Transformer> transformers = this.getPoliciesQueryTransformers(queryType);
            org.nuxeo.ecm.core.query.QueryFilter queryFilter = new org.nuxeo.ecm.core.query.QueryFilter(principal, principals, permissions, null, transformers, 0L, 0L);
            return this.getSession().queryAndFetch(query, queryType, (QueryFilter)queryFilter, distinctDocuments, params);
        }
        catch (QueryParseException e) {
            e.addInfo("Failed to execute query: " + queryType + ": " + query);
            throw e;
        }
    }

    public PartialList<Map<String, Serializable>> queryProjection(String query, long limit, long offset) {
        return this.queryProjection(query, limit, offset, false);
    }

    public PartialList<Map<String, Serializable>> queryProjection(String query, long limit, long offset, boolean countTotal) {
        long countUpTo = this.computeCountUpTo(countTotal);
        return this.queryProjection(query, "NXQL", false, limit, offset, countUpTo, new Object[0]);
    }

    public PartialList<Map<String, Serializable>> queryProjection(String query, String queryType, boolean distinctDocuments, long limit, long offset, long countUpTo, Object ... params) {
        NuxeoPrincipal principal = this.getPrincipal();
        String[] principals = this.getPrincipalsToCheck();
        String[] permissions = this.getPermissionsToCheck("Browse");
        Collection<SQLQuery.Transformer> transformers = this.getPoliciesQueryTransformers(queryType);
        org.nuxeo.ecm.core.query.QueryFilter queryFilter = new org.nuxeo.ecm.core.query.QueryFilter(principal, principals, permissions, null, transformers, limit, offset);
        return this.getSession().queryProjection(query, queryType, (QueryFilter)queryFilter, distinctDocuments, countUpTo, params);
    }

    protected String[] getPrincipalsToCheck() {
        NuxeoPrincipal principal = this.getPrincipal();
        String[] principals = this.isAdministrator() ? null : SecurityService.getPrincipalsToCheck(principal);
        return principals;
    }

    protected Collection<SQLQuery.Transformer> getPoliciesQueryTransformers(String queryType) {
        Collection<SQLQuery.Transformer> transformers;
        if ("NXQL".equals(queryType)) {
            String repoName = this.getRepositoryName();
            transformers = this.getSecurityService().getPoliciesQueryTransformers(repoName);
        } else {
            transformers = Collections.emptyList();
        }
        return transformers;
    }

    public ScrollResult<String> scroll(String query, int batchSize, int keepAliveSeconds) {
        if (this.isAdministrator()) {
            return this.getSession().scroll(query, batchSize, keepAliveSeconds);
        }
        SecurityService securityService = this.getSecurityService();
        NuxeoPrincipal principal = this.getPrincipal();
        String[] principals = this.getPrincipalsToCheck();
        String permission = "Browse";
        String[] permissions = securityService.getPermissionsToCheck(permission);
        Collection<SQLQuery.Transformer> transformers = this.getPoliciesQueryTransformers("NXQL");
        org.nuxeo.ecm.core.query.QueryFilter queryFilter = new org.nuxeo.ecm.core.query.QueryFilter(principal, principals, permissions, null, transformers, 0L, 0L);
        return this.getSession().scroll(query, (QueryFilter)queryFilter, batchSize, keepAliveSeconds);
    }

    public ScrollResult<String> scroll(String scrollId) {
        return this.getSession().scroll(scrollId);
    }

    public void removeChildren(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "RemoveChildren");
        List children = doc.getChildren();
        for (Document child : children) {
            if (!child.isProxy() || !this.hasPermission(child, "Remove")) continue;
            this.removeNotifyOneDoc(child);
        }
        for (Document child : children) {
            if (child.isProxy() || !this.hasPermission(child, "Remove")) continue;
            this.removeNotifyOneDoc(child);
        }
    }

    public boolean canRemoveDocument(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        return this.canRemoveDocument(doc) == null;
    }

    protected String canRemoveDocument(Document doc) {
        if (doc.isVersion()) {
            List proxies = this.getSession().getProxies(doc, null);
            if (!proxies.isEmpty()) {
                return "Proxy " + ((Document)proxies.iterator().next()).getUUID() + " targets version " + doc.getUUID();
            }
            Document working = doc.getSourceDocument();
            if (working != null) {
                Document baseVersion = working.getBaseVersion();
                if (baseVersion != null && !baseVersion.isCheckedOut() && baseVersion.getUUID().equals(doc.getUUID())) {
                    return "Working copy " + working.getUUID() + " is checked in with base version " + doc.getUUID();
                }
                return this.hasPermission(working, "WriteVersion") ? null : "Missing permission 'WriteVersion' on working copy " + working.getUUID();
            }
            return this.isAdministrator() ? null : "No working copy and not an Administrator";
        }
        if (this.isAdministrator()) {
            return null;
        }
        if (!this.hasPermission(doc, "Remove")) {
            return "Missing permission 'Remove' on document " + doc.getUUID();
        }
        Document parent = doc.getParent();
        if (parent == null) {
            return null;
        }
        return this.hasPermission(parent, "RemoveChildren") ? null : "Missing permission 'RemoveChildren' on parent document " + parent.getUUID();
    }

    public void removeDocument(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.removeDocument(doc);
    }

    protected void removeDocument(Document doc) {
        try {
            String reason = this.canRemoveDocument(doc);
            if (reason != null) {
                throw new DocumentSecurityException("Permission denied: cannot remove document " + doc.getUUID() + ", " + reason);
            }
            this.removeNotifyOneDoc(doc);
        }
        catch (ConcurrentUpdateException e) {
            e.addInfo("Failed to remove document " + doc.getUUID());
            throw e;
        }
        this.deleteDocumentCountInc();
    }

    protected void removeNotifyOneDoc(Document doc) {
        DocumentModel docModel = this.readModel(doc);
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        options.put("docTitle", (Serializable)((Object)docModel.getTitle()));
        String versionLabel = "";
        Document sourceDoc = null;
        if (!doc.isVersion()) {
            this.notifyEvent("aboutToRemove", docModel, options, null, null, true, true);
            CoreService coreService = (CoreService)((Object)Framework.getService(CoreService.class));
            coreService.getVersionRemovalPolicy().removeVersions(this.getSession(), doc, this);
        } else {
            versionLabel = docModel.getVersionLabel();
            sourceDoc = doc.getSourceDocument();
            this.notifyEvent("aboutToRemoveVersion", docModel, options, null, null, true, true);
        }
        doc.remove(this.getPrincipal());
        if (doc.isVersion() && sourceDoc != null) {
            DocumentModel sourceDocModel = this.readModel(sourceDoc);
            if (sourceDocModel != null) {
                options.put("comment", (Serializable)((Object)versionLabel));
                this.notifyEvent("versionRemoved", sourceDocModel, options, null, null, false, false);
                options.remove("comment");
            }
            options.put("docSource", (Serializable)((Object)sourceDoc.getUUID()));
        }
        this.notifyEvent("documentRemoved", docModel, options, null, null, false, false);
    }

    public void removeDocuments(DocumentRef[] docRefs) {
        Document[] docs = new Document[docRefs.length];
        for (int i = 0; i < docs.length; ++i) {
            docs[i] = this.resolveReference(docRefs[i]);
        }
        Arrays.sort(docs, pathComparator);
        String[] paths = new String[docs.length];
        for (int i = 0; i < docs.length; ++i) {
            paths[i] = docs[i].getPath();
        }
        Object lastRemovedWithSlash = "\u0000";
        for (int i = 0; i < docs.length; ++i) {
            String path = paths[i];
            if (i != 0 && path != null && path.startsWith((String)lastRemovedWithSlash)) continue;
            this.removeDocument(docs[i]);
            if (path == null) continue;
            lastRemovedWithSlash = path + "/";
        }
    }

    public void save() {
        try {
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            this.getSession().save();
            this.notifyEvent("sessionSaved", null, options, null, null, true, false);
        }
        catch (ConcurrentUpdateException e) {
            e.addInfo("Failed to save session");
            throw e;
        }
    }

    public DocumentModel saveDocument(DocumentModel docModel) {
        boolean setReadWrite;
        boolean manualVersioning;
        DocumentValidationReport report;
        if (docModel.getRef() == null) {
            throw new IllegalArgumentException(String.format("cannot save document '%s' with null reference: document has probably not yet been created in the repository with 'CoreSession.createDocument(docModel)'", docModel.getTitle()));
        }
        Document doc = this.resolveReference(docModel.getRef());
        this.checkPermission(doc, "WriteProperties");
        Map<String, Serializable> options = this.getContextMapEventInfo(docModel);
        boolean dirty = docModel.isDirty();
        if (dirty) {
            CharacterFilteringService charFilteringService = (CharacterFilteringService)Framework.getService(CharacterFilteringService.class);
            charFilteringService.filter(docModel);
        }
        DocumentModel previousDocModel = this.readModel(doc);
        Arrays.asList(previousDocModel.getSchemas()).forEach(arg_0 -> ((DocumentModel)previousDocModel).getProperties(arg_0));
        options.put("previousDocumentModel", (Serializable)previousDocModel);
        options.put("destinationName", (Serializable)((Object)docModel.getName()));
        options.put("documentIsDirty", Boolean.valueOf(dirty));
        this.notifyEvent("beforeDocumentModification", docModel, options, null, null, true, true);
        dirty = docModel.isDirty();
        options.put("documentIsDirty", Boolean.valueOf(dirty));
        if (dirty && this.getValidationService().isActivated("saveDocument", options) && (report = this.getValidationService().validate(docModel, true)).hasError()) {
            throw new DocumentValidationException(report);
        }
        String name = (String)((Object)options.get("destinationName"));
        if (name != null && !name.equals(docModel.getName())) {
            doc = this.getSession().move(doc, doc.getParent(), name);
        }
        VersioningOption versioningOption = (VersioningOption)docModel.getContextData("VersioningOption");
        docModel.putContextData("VersioningOption", null);
        String checkinComment = (String)((Object)docModel.getContextData("CheckinComment"));
        docModel.putContextData("CheckinComment", null);
        Boolean disableAutoCheckOut = (Boolean)docModel.getContextData("DisableAutoCheckOut");
        docModel.putContextData("DisableAutoCheckOut", null);
        options.put("DisableAutoCheckOut", disableAutoCheckOut);
        boolean bl = manualVersioning = versioningOption != null;
        if (!docModel.isImmutable()) {
            boolean checkout;
            if (previousDocModel.isCheckedOut() && (!manualVersioning || dirty)) {
                this.getVersioningService().doAutomaticVersioning(previousDocModel, docModel, true);
            }
            if (checkout = this.getVersioningService().isPreSaveDoingCheckOut(doc, dirty, versioningOption, options)) {
                this.notifyEvent("aboutToCheckout", docModel, options, null, null, true, true);
            }
            versioningOption = this.getVersioningService().doPreSave((CoreSession)this, doc, dirty, versioningOption, checkinComment, options);
            if (checkout) {
                DocumentModel checkedOutDoc = this.readModel(doc);
                this.notifyEvent("documentCheckedOut", checkedOutDoc, options, null, null, true, false);
            }
        }
        boolean allowVersionWrite = Boolean.TRUE.equals(docModel.getContextData("allowVersionWrite"));
        docModel.putContextData("allowVersionWrite", null);
        boolean bl2 = setReadWrite = allowVersionWrite && doc.isVersion() && doc.isReadOnly();
        if (setReadWrite) {
            doc.setReadOnly(false);
        }
        docModel = this.writeModel(doc, docModel);
        if (setReadWrite) {
            doc.setReadOnly(true);
        }
        Document checkedInDoc = null;
        if (!docModel.isImmutable()) {
            boolean checkin = this.getVersioningService().isPostSaveDoingCheckIn(doc, versioningOption, options);
            if (checkin) {
                this.notifyEvent("aboutToCheckIn", docModel, options, null, null, true, true);
            }
            if (manualVersioning) {
                checkedInDoc = this.getVersioningService().doPostSave((CoreSession)this, doc, versioningOption, checkinComment, options);
            } else {
                this.getVersioningService().doAutomaticVersioning(previousDocModel, docModel, false);
            }
        }
        docModel = this.readModel(doc);
        if (checkedInDoc != null) {
            IdRef checkedInVersionRef = new IdRef(checkedInDoc.getUUID());
            this.notifyCheckedInVersion(docModel, (DocumentRef)checkedInVersionRef, options, checkinComment);
        }
        this.notifyEvent("documentModified", docModel, options, null, null, true, false);
        this.updateDocumentCountInc();
        List proxies = this.getSession().getProxies(doc);
        if (proxies != null && !proxies.isEmpty()) {
            proxies.forEach(proxy -> {
                DocumentModel docProxy = this.readModel((Document)proxy);
                if (!docProxy.isImmutable()) {
                    this.notifyEvent("documentProxyUpdated", docProxy, options, null, null, true, false);
                }
            });
        }
        return docModel;
    }

    public void saveDocuments(DocumentModel[] docModels) {
        for (DocumentModel docModel : docModels) {
            this.saveDocument(docModel);
        }
    }

    public DocumentModel getSourceDocument(DocumentRef docRef) {
        assert (null != docRef);
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "ReadVersion");
        Document headDocument = doc.getSourceDocument();
        if (headDocument == null) {
            throw new DocumentNotFoundException("Source document has been deleted");
        }
        return this.readModel(headDocument);
    }

    protected VersionModel getVersionModel(Document version) {
        VersionModelImpl versionModel = new VersionModelImpl();
        versionModel.setId(version.getUUID());
        versionModel.setCreated(version.getVersionCreationDate());
        versionModel.setDescription(version.getCheckinComment());
        versionModel.setLabel(version.getVersionLabel());
        return versionModel;
    }

    public DocumentModel getLastDocumentVersion(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "ReadVersion");
        Document version = doc.getLastVersion();
        return version == null ? null : this.readModel(version);
    }

    public DocumentRef getLastDocumentVersionRef(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "ReadVersion");
        Document version = doc.getLastVersion();
        return version == null ? null : new IdRef(version.getUUID());
    }

    public List<DocumentRef> getVersionsRefs(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "ReadVersion");
        List ids = doc.getVersionsIds();
        ArrayList<DocumentRef> refs = new ArrayList<DocumentRef>(ids.size());
        for (String id : ids) {
            refs.add((DocumentRef)new IdRef(id));
        }
        return refs;
    }

    public List<DocumentModel> getVersions(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "ReadVersion");
        List docVersions = doc.getVersions();
        ArrayList<DocumentModel> versions = new ArrayList<DocumentModel>(docVersions.size());
        for (Document version : docVersions) {
            versions.add(this.readModel(version));
        }
        return versions;
    }

    public List<VersionModel> getVersionsForDocument(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "ReadVersion");
        List docVersions = doc.getVersions();
        ArrayList<VersionModel> versions = new ArrayList<VersionModel>(docVersions.size());
        for (Document version : docVersions) {
            versions.add(this.getVersionModel(version));
        }
        return versions;
    }

    public DocumentModel restoreToVersion(DocumentRef docRef, DocumentRef versionRef) {
        Document doc = this.resolveReference(docRef);
        Document ver = this.resolveReference(versionRef);
        return this.restoreToVersion(doc, ver, false, true);
    }

    public DocumentModel restoreToVersion(DocumentRef docRef, DocumentRef versionRef, boolean skipSnapshotCreation, boolean skipCheckout) {
        Document doc = this.resolveReference(docRef);
        Document ver = this.resolveReference(versionRef);
        return this.restoreToVersion(doc, ver, skipSnapshotCreation, skipCheckout);
    }

    protected DocumentModel restoreToVersion(Document doc, Document version, boolean skipSnapshotCreation, boolean skipCheckout) {
        this.checkPermission(doc, "WriteVersion");
        if (doc.isRecord()) {
            throw new PropertyException("Version cannot be restored on a record: " + doc.getUUID());
        }
        DocumentModel docModel = this.readModel(doc);
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        if (!skipSnapshotCreation && doc.isCheckedOut()) {
            String checkinComment = (String)((Object)docModel.getContextData("CheckinComment"));
            docModel.putContextData("CheckinComment", null);
            this.notifyEvent("aboutToCheckIn", docModel, options, null, null, true, true);
            Document ver = this.getVersioningService().doCheckIn(doc, null, checkinComment);
            docModel.refresh(1, null);
            this.notifyCheckedInVersion(docModel, (DocumentRef)new IdRef(ver.getUUID()), null, checkinComment);
        }
        Long majorVer = (Long)doc.getPropertyValue("major_version");
        Long minorVer = (Long)doc.getPropertyValue("minor_version");
        if (majorVer != null || minorVer != null) {
            options.put("CURRENT_DOCUMENT_MAJOR_VERSION", majorVer);
            options.put("CURRENT_DOCUMENT_MINOR_VERSION", minorVer);
        }
        String versionUUID = version.getUUID();
        options.put("RESTORED_VERSION_UUID", (Serializable)((Object)versionUUID));
        this.notifyEvent("beforeRestoringDocument", docModel, options, null, null, true, true);
        this.writeModel(doc, docModel);
        doc.restore(version);
        docModel = this.readModel(doc);
        this.notifyEvent("documentRestored", docModel, options, null, docModel.getVersionLabel(), true, false);
        docModel = this.writeModel(doc, docModel);
        if (!skipCheckout) {
            this.notifyEvent("aboutToCheckout", docModel, options, null, null, true, true);
            this.getVersioningService().doCheckOut(doc);
            docModel = this.readModel(doc);
            this.notifyEvent("documentCheckedOut", docModel, options, null, null, true, false);
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> ((Document)version).getUUID();
        log.debug("Document restored to version:{}", supplierArray);
        return docModel;
    }

    public DocumentRef getBaseVersion(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "Read");
        Document ver = doc.getBaseVersion();
        if (ver == null) {
            return null;
        }
        this.checkPermission(ver, "Read");
        return new IdRef(ver.getUUID());
    }

    public DocumentRef checkIn(DocumentRef docRef, VersioningOption option, String checkinComment) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "WriteProperties");
        DocumentModel docModel = this.readModel(doc);
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        this.notifyEvent("aboutToCheckIn", docModel, options, null, null, true, true);
        this.writeModel(doc, docModel);
        Document version = this.getVersioningService().doCheckIn(doc, option, checkinComment);
        docModel = this.readModel(doc);
        IdRef checkedInVersionRef = new IdRef(version.getUUID());
        this.notifyCheckedInVersion(docModel, (DocumentRef)checkedInVersionRef, options, checkinComment);
        this.writeModel(doc, docModel);
        return checkedInVersionRef;
    }

    protected void notifyCheckedInVersion(DocumentModel docModel, DocumentRef checkedInVersionRef, Map<String, Serializable> options, String checkinComment) {
        Serializable optionsComment;
        String label = this.getVersioningService().getVersionLabel(docModel);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        if (options != null) {
            props.putAll(options);
        }
        props.put("versionLabel", (Serializable)((Object)label));
        props.put("checkInComment", (Serializable)((Object)checkinComment));
        props.put("checkedInVersionRef", (Serializable)checkedInVersionRef);
        if (checkinComment == null && options != null && (optionsComment = options.get("comment")) instanceof String) {
            checkinComment = (String)((Object)optionsComment);
        }
        String comment = checkinComment == null ? label : label + " " + checkinComment;
        props.put("comment", (Serializable)((Object)comment));
        this.notifyEvent("documentCheckedIn", docModel, props, null, null, true, false);
        this.notifyEvent("documentCreated", this.getDocument(checkedInVersionRef), props, null, null, true, false);
    }

    public void checkOut(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "WriteProperties");
        DocumentModel docModel = this.readModel(doc);
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        this.notifyEvent("aboutToCheckout", docModel, options, null, null, true, true);
        this.getVersioningService().doCheckOut(doc);
        docModel = this.readModel(doc);
        this.notifyEvent("documentCheckedOut", docModel, options, null, null, true, false);
        this.writeModel(doc, docModel);
    }

    public boolean isCheckedOut(DocumentRef docRef) {
        assert (null != docRef);
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "Browse");
        return doc.isCheckedOut();
    }

    public String getVersionSeriesId(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "Read");
        return doc.getVersionSeriesId();
    }

    public DocumentModel getWorkingCopy(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "ReadVersion");
        Document pwc = doc.getWorkingCopy();
        this.checkPermission(pwc, "Read");
        return pwc == null ? null : this.readModel(pwc);
    }

    public DocumentModel getVersion(String versionableId, VersionModel versionModel) {
        String id = versionModel.getId();
        if (id != null) {
            return this.getDocument((DocumentRef)new IdRef(id));
        }
        Document doc = this.getSession().getVersion(versionableId, versionModel);
        if (doc == null) {
            return null;
        }
        this.checkPermission(doc, "ReadProperties");
        this.checkPermission(doc, "ReadVersion");
        return this.readModel(doc);
    }

    public String getVersionLabel(DocumentModel docModel) {
        return this.getVersioningService().getVersionLabel(docModel);
    }

    public DocumentModel getDocumentWithVersion(DocumentRef docRef, VersionModel version) {
        String id = version.getId();
        if (id != null) {
            return this.getDocument((DocumentRef)new IdRef(id));
        }
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "ReadProperties");
        this.checkPermission(doc, "ReadVersion");
        String docPath = doc.getPath();
        doc = doc.getVersion(version.getLabel());
        if (doc == null) {
            log.debug("Version {} does not exist for {}", (Object)version.getLabel(), (Object)docPath);
            return null;
        }
        log.debug("Retrieved the version {} of the document {}", (Object)version.getLabel(), (Object)docPath);
        return this.readModel(doc);
    }

    public DocumentModel createProxy(DocumentRef docRef, DocumentRef folderRef) {
        Document doc = this.resolveReference(docRef);
        Document fold = this.resolveReference(folderRef);
        this.checkPermission(doc, "Read");
        this.checkPermission(fold, "AddChildren");
        return this.createProxyInternal(doc, fold, new HashMap<String, Serializable>());
    }

    protected DocumentModel createProxyInternal(Document doc, Document folder, Map<String, Serializable> options) {
        Document proxy = this.getSession().createProxy(doc, folder);
        DocumentModel proxyModel = this.readModel(proxy);
        this.notifyEvent("documentCreated", proxyModel, options, null, null, true, false);
        this.notifyEvent("documentProxyPublished", proxyModel, options, null, null, true, false);
        DocumentModel folderModel = this.readModel(folder);
        this.notifyEvent("sectionContentPublished", folderModel, options, null, null, true, false);
        return proxyModel;
    }

    protected List<String> removeExistingProxies(Document doc, Document folder) {
        List otherProxies = this.getSession().getProxies(doc, folder);
        ArrayList<String> removedProxyIds = new ArrayList<String>(otherProxies.size());
        for (Document otherProxy : otherProxies) {
            removedProxyIds.add(otherProxy.getUUID());
            this.removeNotifyOneDoc(otherProxy);
        }
        return removedProxyIds;
    }

    protected DocumentModel updateExistingProxies(Document doc, Document folder, Document target) {
        List proxies = this.getSession().getProxies(doc, folder);
        try {
            if (proxies.size() == 1) {
                Document proxy = (Document)proxies.iterator().next();
                proxy.setTargetDocument(target);
                return this.readModel(proxy);
            }
        }
        catch (UnsupportedOperationException e) {
            log.error("Cannot update proxy, try to remove");
        }
        return null;
    }

    public DocumentModelList getProxies(DocumentRef docRef, DocumentRef folderRef) {
        Document folder = null;
        if (folderRef != null) {
            folder = this.resolveReference(folderRef);
            this.checkPermission(folder, "ReadChildren");
        }
        Document doc = this.resolveReference(docRef);
        List children = this.getSession().getProxies(doc, folder);
        DocumentModelListImpl docs = new DocumentModelListImpl();
        for (Document child : children) {
            if (!this.hasPermission(child, "Read")) continue;
            docs.add((Object)this.readModel(child));
        }
        return docs;
    }

    public List<String> getAvailableSecurityPermissions() {
        return Arrays.asList(this.getSecurityService().getPermissionProvider().getPermissions());
    }

    public DataModel getDataModel(DocumentRef docRef, Schema schema) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "Read");
        return DocumentModelFactory.createDataModel(doc, schema);
    }

    protected Object getDataModelField(DocumentRef docRef, String schema, String field) {
        Document doc = this.resolveReference(docRef);
        if (doc != null) {
            this.checkPermission(doc, "Read");
            Schema docSchema = doc.getType().getSchema(schema);
            if (docSchema != null) {
                String prefix = docSchema.getNamespace().prefix;
                if (prefix != null && prefix.length() > 0) {
                    field = prefix + ":" + (String)field;
                }
                return doc.getPropertyValue((String)field);
            }
            log.warn("Cannot find schema with name={}", (Object)schema);
        } else {
            log.warn("Cannot resolve docRef={}", (Object)docRef);
        }
        return null;
    }

    public void makeRecord(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "Read");
        if (doc.isRecord()) {
            return;
        }
        if (doc.isVersion()) {
            throw new PropertyException("Version cannot be made record: " + doc.getUUID());
        }
        this.checkPermission(doc, "MakeRecord");
        DocumentModel docModel = this.readModel(doc);
        this.notifyEvent("beforeMakeRecord", docModel, null, null, null, true, false);
        doc.makeRecord();
        docModel = this.readModel(doc);
        this.notifyEvent("afterMakeRecord", docModel, null, null, null, true, false);
    }

    public boolean isRecord(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "Read");
        return doc.isRecord();
    }

    public void setRetainUntil(DocumentRef docRef, Calendar retainUntil, String comment) throws PropertyException {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "Read");
        if (!doc.isRecord()) {
            throw new PropertyException("Document is not a record");
        }
        Calendar current = doc.getRetainUntil();
        if (current != null && retainUntil != null && current.compareTo(retainUntil) == 0) {
            return;
        }
        this.checkPermission(doc, "SetRetention");
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        options.put("retainUntil", retainUntil);
        boolean retainUntilIndeterminate = retainUntil == null || RETAIN_UNTIL_INDETERMINATE.compareTo(retainUntil) == 0;
        options.put("comment", (Serializable)((Object)(retainUntilIndeterminate ? "" : retainUntil.toInstant().toString())));
        DocumentModel docModel = this.readModel(doc);
        boolean currentIndeterminate = current == null || RETAIN_UNTIL_INDETERMINATE.compareTo(current) == 0;
        String beforeRetentionEvent = currentIndeterminate ? "beforeSetRetention" : "beforeExtendRetention";
        this.notifyEvent(beforeRetentionEvent, docModel, options, null, null, true, false);
        doc.setRetainUntil(retainUntil);
        docModel = this.readModel(doc);
        String afterRetentionEvent = currentIndeterminate ? "afterSetRetention" : "afterExtendRetention";
        this.notifyEvent(afterRetentionEvent, docModel, options, null, null, true, false);
    }

    public Calendar getRetainUntil(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "Read");
        return doc.getRetainUntil();
    }

    public void setLegalHold(DocumentRef docRef, boolean hold, String comment) {
        Document doc = this.resolveReference(docRef);
        if (!this.isRecord(docRef)) {
            throw new PropertyException("Document is not a record");
        }
        if (this.hasLegalHold(docRef) == hold) {
            return;
        }
        this.checkPermission(doc, "ManageLegalHold");
        DocumentModel docModel = this.readModel(doc);
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        options.put("comment", (Serializable)((Object)StringUtils.defaultString((String)comment)));
        String beforeLegalHoldEvent = hold ? "beforeSetLegalHold" : "beforeRemoveLegalHold";
        this.notifyEvent(beforeLegalHoldEvent, docModel, options, null, null, true, false);
        doc.setLegalHold(hold);
        docModel = this.readModel(doc);
        String afterLegalHoldEvent = hold ? "afterSetLegalHold" : "afterRemoveLegalHold";
        this.notifyEvent(afterLegalHoldEvent, docModel, options, null, null, true, false);
    }

    public boolean hasLegalHold(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "Read");
        return doc.hasLegalHold();
    }

    public boolean isUnderRetentionOrLegalHold(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "Read");
        return doc.isUnderRetentionOrLegalHold();
    }

    public boolean isRetentionActive(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "Read");
        return doc.isRetentionActive();
    }

    public void setRetentionActive(DocumentRef docRef, boolean retentionActive) {
        Document doc = this.resolveReference(docRef);
        if (this.isRetentionActive(docRef) == retentionActive) {
            return;
        }
        this.checkPermission(doc, retentionActive ? "Write" : "WriteSecurity");
        doc.setRetentionActive(retentionActive);
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        options.put("retentionActive", Boolean.valueOf(retentionActive));
        options.put("comment", (Serializable)((Object)Boolean.toString(retentionActive)));
        DocumentModel docModel = this.readModel(doc);
        this.notifyEvent("retentionActiveChanged", docModel, options, null, null, true, false);
    }

    public boolean isTrashed(DocumentRef docRef) {
        return ((TrashService)Framework.getService(TrashService.class)).isTrashed((CoreSession)this, docRef);
    }

    public String getCurrentLifeCycleState(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "ReadLifeCycle");
        return doc.getLifeCycleState();
    }

    public String getLifeCyclePolicy(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "ReadLifeCycle");
        return doc.getLifeCyclePolicy();
    }

    private boolean followTransition(DocumentRef docRef, String transition, Map<String, Serializable> options) throws LifeCycleException {
        boolean deleteTransitions;
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "WriteLifeCycle");
        TrashService trashService = (TrashService)Framework.getService(TrashService.class);
        boolean bl = deleteTransitions = "delete".equals(transition) || "undelete".equals(transition);
        if (deleteTransitions && !trashService.hasFeature(TrashService.Feature.TRASHED_STATE_IS_DEDUCED_FROM_LIFECYCLE) && !Boolean.TRUE.equals(options.get("fromLifeCycleTrashService"))) {
            String message = "Following the transition '" + transition + "' is deprecated. Please use TrashService.";
            if (log.isTraceEnabled()) {
                log.warn(message, new Throwable("stack trace"));
            } else {
                log.warn(message);
            }
            DocumentModel docModel = this.readModel(doc);
            if ("delete".equals(transition)) {
                trashService.trashDocument(docModel);
            } else {
                trashService.untrashDocument(docModel);
            }
            return true;
        }
        if (!(doc.isVersion() || doc.isProxy() || doc.isCheckedOut() || deleteTransitions && !((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanFalse(TRASH_KEEP_CHECKED_IN_PROPERTY))) {
            this.checkOut(docRef);
            doc = this.resolveReference(docRef);
        }
        String formerStateName = doc.getLifeCycleState();
        doc.followTransition(transition);
        HashMap<String, Serializable> eventOptions = new HashMap<String, Serializable>(options);
        eventOptions.put("from", (Serializable)((Object)formerStateName));
        eventOptions.put("to", (Serializable)((Object)doc.getLifeCycleState()));
        eventOptions.put("transition", (Serializable)((Object)transition));
        String comment = (String)((Object)options.get("comment"));
        DocumentModel docModel = this.readModel(doc);
        this.notifyEvent("lifecycle_transition_event", docModel, eventOptions, "eventLifeCycleCategory", comment, true, false);
        if (!docModel.isImmutable()) {
            this.writeModel(doc, docModel);
        }
        return true;
    }

    public boolean followTransition(DocumentModel docModel, String transition) throws LifeCycleException {
        return this.followTransition(docModel.getRef(), transition, docModel.getContextData());
    }

    public boolean followTransition(DocumentRef docRef, String transition) throws LifeCycleException {
        return this.followTransition(docRef, transition, Collections.emptyMap());
    }

    public Collection<String> getAllowedStateTransitions(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "ReadLifeCycle");
        return doc.getAllowedStateTransitions();
    }

    public void reinitLifeCycleState(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "WriteLifeCycle");
        this.getLifeCycleService().reinitLifeCycle(doc);
    }

    public Object[] getDataModelsField(DocumentRef[] docRefs, String schema, String field) {
        assert (docRefs != null);
        assert (schema != null);
        assert (field != null);
        Object[] values = new Object[docRefs.length];
        int i = 0;
        for (DocumentRef docRef : docRefs) {
            Object value = this.getDataModelField(docRef, schema, field);
            values[i++] = value;
        }
        return values;
    }

    public DocumentRef[] getParentDocumentRefs(DocumentRef docRef) {
        ArrayList<IdRef> docRefs = new ArrayList<IdRef>();
        for (Document parentDoc = this.resolveParentReference(docRef); parentDoc != null; parentDoc = parentDoc.getParent()) {
            IdRef parentDocRef = new IdRef(parentDoc.getUUID());
            docRefs.add(parentDocRef);
        }
        DocumentRef[] refs = new DocumentRef[docRefs.size()];
        return docRefs.toArray(refs);
    }

    public Object[] getDataModelsFieldUp(DocumentRef docRef, String schema, String field) {
        DocumentRef[] parentRefs = this.getParentDocumentRefs(docRef);
        DocumentRef[] allRefs = new DocumentRef[parentRefs.length + 1];
        allRefs[0] = docRef;
        System.arraycopy(parentRefs, 0, allRefs, 1, parentRefs.length);
        return this.getDataModelsField(allRefs, schema, field);
    }

    public Lock setLock(DocumentRef docRef) throws LockException {
        Document doc = this.resolveReference(docRef);
        try {
            LockSecurityPolicy.setIgnorePolicy(true);
            this.checkPermission(doc, "WriteProperties");
        }
        finally {
            LockSecurityPolicy.setIgnorePolicy(false);
        }
        Lock lock = new Lock(this.getPrincipal().getName(), (Calendar)new GregorianCalendar());
        Lock oldLock = doc.setLock(lock);
        if (oldLock == null) {
            DocumentModel docModel = this.readModel(doc);
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            options.put("lock", (Serializable)lock);
            this.notifyEvent("documentLocked", docModel, options, null, null, true, false);
            return lock;
        }
        if (this.getPrincipal().getName().equals(oldLock.getOwner())) {
            return oldLock;
        }
        throw new LockException("Document already locked by " + oldLock.getOwner() + ": " + docRef, 409);
    }

    public Lock getLockInfo(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        this.checkPermission(doc, "Read");
        return doc.getLock();
    }

    public Lock removeLock(DocumentRef docRef) throws LockException {
        String owner;
        Document doc = this.resolveReference(docRef);
        Lock lock = doc.removeLock(owner = this.hasPermission(docRef, "Unlock") ? null : this.getPrincipal().getName());
        if (lock == null) {
            return null;
        }
        if (lock.getFailed()) {
            throw new LockException("Document already locked by " + lock.getOwner() + ": " + docRef, 409);
        }
        DocumentModel docModel = this.readModel(doc);
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        options.put("lock", (Serializable)lock);
        this.notifyEvent("documentUnlocked", docModel, options, null, null, true, false);
        return lock;
    }

    protected boolean isAdministrator() {
        NuxeoPrincipal principal = this.getPrincipal();
        if (Framework.isTestModeSet() && "Administrator".equals(principal.getName())) {
            return true;
        }
        return principal.isAdministrator();
    }

    public void applyDefaultPermissions(String userOrGroupName) {
        if (userOrGroupName == null) {
            throw new NullPointerException("null userOrGroupName");
        }
        if (!this.isAdministrator()) {
            throw new DocumentSecurityException("You need to be an Administrator to do this.");
        }
        DocumentModel rootDocument = this.getRootDocument();
        ACPImpl acp = new ACPImpl();
        UserEntryImpl userEntry = new UserEntryImpl(userOrGroupName);
        userEntry.addPrivilege("Read");
        acp.setRules(new UserEntry[]{userEntry});
        this.setACP(rootDocument.getRef(), (ACP)acp, false);
    }

    public DocumentModel publishDocument(DocumentModel docToPublish, DocumentModel section) {
        return this.publishDocument(docToPublish, section, true);
    }

    public DocumentModel publishDocument(DocumentModel docModel, DocumentModel section, boolean overwriteExistingProxy) {
        Document target;
        Document doc = this.resolveReference(docModel.getRef());
        Document sec = this.resolveReference(section.getRef());
        this.checkPermission(doc, "Read");
        this.checkPermission(sec, "AddChildren");
        if (doc.isRecord()) {
            throw new PropertyException("Record cannot be published: " + doc.getUUID());
        }
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        DocumentModel proxy = null;
        if (docModel.isProxy() || docModel.isVersion()) {
            target = doc;
            if (overwriteExistingProxy) {
                if (docModel.isVersion()) {
                    Document base = this.resolveReference((DocumentRef)new IdRef(doc.getVersionSeriesId()));
                    proxy = this.updateExistingProxies(base, sec, target);
                }
                if (proxy == null) {
                    List<String> removedProxyIds = this.removeExistingProxies(doc, sec);
                    options.put("replacedProxyRefs", (Serializable)((Object)removedProxyIds));
                }
            }
        } else {
            String checkinComment = (String)((Object)docModel.getContextData("CheckinComment"));
            docModel.putContextData("CheckinComment", null);
            if (doc.isCheckedOut() || doc.getLastVersion() == null) {
                if (!doc.isCheckedOut()) {
                    this.notifyEvent("aboutToCheckout", docModel, options, null, null, true, true);
                    this.getVersioningService().doCheckOut(doc);
                    docModel = this.readModel(doc);
                    this.notifyEvent("documentCheckedOut", docModel, options, null, null, true, false);
                }
                this.notifyEvent("aboutToCheckIn", docModel, options, null, null, true, true);
                Document version = this.getVersioningService().doCheckIn(doc, null, checkinComment);
                docModel.refresh(129, null);
                this.notifyCheckedInVersion(docModel, (DocumentRef)new IdRef(version.getUUID()), null, checkinComment);
            }
            target = doc.getBaseVersion();
            if (overwriteExistingProxy) {
                proxy = this.updateExistingProxies(doc, sec, target);
                if (proxy == null) {
                    List<String> removedProxyIds = this.removeExistingProxies(doc, sec);
                    options.put("replacedProxyRefs", (Serializable)((Object)removedProxyIds));
                } else {
                    this.notifyEvent("documentProxyUpdated", proxy, options, null, null, true, false);
                    this.notifyEvent("documentProxyPublished", proxy, options, null, null, true, false);
                    this.notifyEvent("sectionContentPublished", section, options, null, null, true, false);
                }
            }
        }
        if (proxy == null) {
            proxy = this.createProxyInternal(target, sec, options);
        }
        return proxy;
    }

    public String getSuperParentType(DocumentModel doc) {
        DocumentModel superSpace = this.getSuperSpace(doc);
        if (superSpace == null) {
            return null;
        }
        return superSpace.getType();
    }

    public DocumentModel getSuperSpace(DocumentModel doc) {
        if (doc == null) {
            throw new IllegalArgumentException("null document");
        }
        if (doc.hasFacet("SuperSpace")) {
            return doc;
        }
        DocumentModel parent = this.getDirectAccessibleParent(doc.getRef());
        if (parent == null || "/".equals(parent.getPathAsString())) {
            return this.getRootDocument();
        }
        return this.getSuperSpace(parent);
    }

    private DocumentModel getDirectAccessibleParent(DocumentRef docRef) {
        Document doc = this.resolveReference(docRef);
        Document parentDoc = doc.getParent();
        if (parentDoc == null) {
            return null;
        }
        if (!this.hasPermission(parentDoc, "Read")) {
            String parentPath = parentDoc.getPath();
            if ("/".equals(parentPath)) {
                return this.getRootDocument();
            }
            return this.getDirectAccessibleParent((DocumentRef)new PathRef(parentDoc.getPath()));
        }
        return this.readModel(parentDoc);
    }

    public <T extends Serializable> T getDocumentSystemProp(DocumentRef ref, String systemProperty, Class<T> type) {
        Document doc = this.resolveReference(ref);
        return (T)doc.getSystemProp(systemProperty, type);
    }

    public <T extends Serializable> void setDocumentSystemProp(DocumentRef ref, String systemProperty, T value) {
        Document doc = this.resolveReference(ref);
        if (systemProperty != null && systemProperty.startsWith(BINARY_TEXT_SYS_PROP)) {
            DocumentModel docModel = this.readModel(doc);
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            options.put(systemProperty, Boolean.valueOf(value != null));
            options.put("systemProperty", (Serializable)((Object)systemProperty));
            options.put("systemPropertyValue", value);
            this.notifyEvent("binaryTextUpdated", docModel, options, null, null, false, true);
        }
        doc.setSystemProp(systemProperty, value);
    }

    public String getChangeToken(DocumentRef ref) {
        Document doc = this.resolveReference(ref);
        return doc.getChangeToken();
    }

    public void orderBefore(DocumentRef parent, String src, String dest) {
        if (src == null || src.equals(dest)) {
            return;
        }
        Document doc = this.resolveReference(parent);
        doc.orderBefore(src, dest);
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        DocumentModel docModel = this.readModel(doc);
        options.put("reorderedChild", (Serializable)((Object)src));
        this.notifyEvent("childrenOrderChanged", docModel, options, null, src, true, false);
    }

    public DocumentModel.DocumentModelRefresh refreshDocument(DocumentRef ref, int refreshFlags, String[] schemas) {
        Document doc = this.resolveReference(ref);
        if ((refreshFlags & 0x101) != 0) {
            this.checkPermission(doc, "Read");
        }
        if ((refreshFlags & 0x20) != 0) {
            this.checkPermission(doc, "ReadSecurity");
        }
        DocumentModel.DocumentModelRefresh refresh = DocumentModelFactory.refreshDocumentModel(doc, refreshFlags, schemas);
        if ((refreshFlags & 0x20) != 0) {
            refresh.acp = this.getSession().getMergedACP(doc);
        }
        if ((refreshFlags & 1) != 0) {
            refresh.isTrashed = this.isTrashed(ref);
        }
        return refresh;
    }

    public String[] getPermissionsToCheck(String permission) {
        return this.getSecurityService().getPermissionsToCheck(permission);
    }

    public <T extends DetachedAdapter> T adaptFirstMatchingDocumentWithFacet(DocumentRef docRef, String facet, Class<T> adapterClass) {
        Document doc = this.getFirstParentDocumentWithFacet(docRef, facet);
        if (doc != null) {
            DocumentModel docModel = this.readModel(doc);
            this.loadDataModelsForFacet(docModel, doc, facet);
            docModel.detach(false);
            return (T)((DetachedAdapter)docModel.getAdapter(adapterClass));
        }
        return null;
    }

    protected void loadDataModelsForFacet(DocumentModel docModel, Document doc, String facetName) {
        String[] facetSchemas;
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        CompositeType facet = schemaManager.getFacet(facetName);
        if (facet == null) {
            return;
        }
        for (String schema : facetSchemas = facet.getSchemaNames()) {
            DataModel dm = DocumentModelFactory.createDataModel(doc, schemaManager.getSchema(schema));
            docModel.getDataModels().put(schema, dm);
        }
    }

    protected Document getFirstParentDocumentWithFacet(DocumentRef docRef, String facet) {
        Document doc;
        for (doc = this.resolveReference(docRef); doc != null && !doc.hasFacet(facet); doc = doc.getParent()) {
        }
        return doc;
    }

    public Map<String, String> getBinaryFulltext(DocumentRef ref) {
        Document doc = this.resolveReference(ref);
        this.checkPermission(doc, "Read");
        String id = doc.getUUID();
        if (doc.isProxy()) {
            id = doc.getTargetDocument().getUUID();
        }
        return this.getSession().getBinaryFulltext(id);
    }

    public DocumentModel getOrCreateDocument(DocumentModel docModel) {
        return this.getOrCreateDocument(docModel, Function.identity());
    }

    public DocumentModel getOrCreateDocument(DocumentModel docModel, Function<DocumentModel, DocumentModel> postCreate) {
        DocumentRef ref = docModel.getRef();
        if (this.exists(ref)) {
            return this.getDocument(ref);
        }
        if (docModel.getParentRef() == null) {
            return postCreate.apply(this.createDocument(docModel));
        }
        String key = this.computeKeyForAtomicCreation(docModel);
        return (DocumentModel)LockHelper.doAtomically((String)key, () -> {
            if (this.exists(ref)) {
                return this.getDocument(ref);
            }
            return (DocumentModel)postCreate.apply(this.createDocument(docModel));
        });
    }

    public DocumentModel newDocumentModel(DocumentRef parentRef, String name, String typeName) {
        if (parentRef == null && name == null) {
            return this.createDocumentModel(typeName);
        }
        String parentPath = parentRef == null ? null : this.resolveReference(parentRef).getPath();
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        options.put("parentPath", (Serializable)((Object)parentPath));
        options.put("documentModelId", (Serializable)((Object)name));
        options.put("destinationName", (Serializable)((Object)name));
        return this.createDocumentModelFromParentAndType(parentRef, typeName, options);
    }

    protected String computeKeyForAtomicCreation(DocumentModel docModel) {
        String repositoryName = docModel.getRepositoryName();
        if (repositoryName == null) {
            repositoryName = this.getRepositoryName();
        }
        String parentId = this.getDocument(docModel.getParentRef()).getId();
        String name = docModel.getName();
        return repositoryName + "-" + parentId + "-" + name;
    }
}

