/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.nuxeo.ecm.core.api.NuxeoException;

public class CursorResult<C, O>
implements Iterator<O>,
Closeable {
    protected C cursor;
    protected final int batchSize;
    protected final int keepAliveSeconds;
    protected long lastCallTimestamp;

    public CursorResult(C cursor, int batchSize, int keepAliveSeconds) {
        this.cursor = cursor;
        this.batchSize = batchSize;
        this.keepAliveSeconds = keepAliveSeconds;
        this.lastCallTimestamp = System.currentTimeMillis();
    }

    public C getCursor() {
        return this.cursor;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void touch() {
        this.lastCallTimestamp = System.currentTimeMillis();
    }

    public boolean timedOut() {
        long now = System.currentTimeMillis();
        return now - this.lastCallTimestamp > (long)(this.keepAliveSeconds * 1000);
    }

    @Override
    public boolean hasNext() {
        if (this.cursor == null) {
            return false;
        }
        if (this.cursor instanceof Iterator) {
            return ((Iterator)this.cursor).hasNext();
        }
        throw new IllegalStateException("Cursor doesn't implement Iterator interface, you must provide an implementation of #hasNext and #next method");
    }

    @Override
    public O next() {
        if (this.cursor instanceof Iterator) {
            return (O)((Iterator)this.cursor).next();
        }
        throw new IllegalStateException("Cursor doesn't implement Iterator interface, you must provide an implementation of #hasNext and #next method");
    }

    @Override
    public void close() {
        if (this.cursor instanceof Closeable) {
            try {
                ((Closeable)this.cursor).close();
            }
            catch (IOException e) {
                throw new NuxeoException("Unable to close cursor", e);
            }
        }
        this.cursor = null;
    }
}

