/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.validation;

import java.util.ArrayList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.validation.DocumentValidationReport;
import org.nuxeo.ecm.core.api.validation.GlobalViolation;
import org.nuxeo.ecm.core.api.validation.ValidationViolation;

public class DocumentValidationException
extends NuxeoException {
    private static final String MESSAGE_SINGLE = "Constraint violation thrown: '%s'";
    private static final String MESSAGE = "%s constraint violation(s) thrown. First one is: '%s', call " + DocumentValidationException.class.getSimpleName() + ".getViolations() to get the others";
    private static final long serialVersionUID = 1L;
    private DocumentValidationReport report;

    public DocumentValidationException(DocumentValidationReport report) {
        super(422);
        this.report = report;
    }

    public DocumentValidationException(String message) {
        super(message, 422);
        ArrayList<ValidationViolation> violations = new ArrayList<ValidationViolation>();
        violations.add(new GlobalViolation(message));
        this.report = new DocumentValidationReport(violations);
    }

    public DocumentValidationReport getReport() {
        return this.report;
    }

    @Override
    public String getMessage() {
        if (this.report.hasError()) {
            int num = this.report.numberOfErrors();
            String violationMessage = this.report.asList().get(0).getMessageKey();
            if (num > 1) {
                return String.format(MESSAGE, this.report.numberOfErrors(), violationMessage);
            }
            return String.format(MESSAGE_SINGLE, violationMessage);
        }
        return super.getMessage();
    }
}

