/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobContext;
import org.nuxeo.ecm.core.blob.BlobStore;
import org.nuxeo.ecm.core.blob.BlobUpdateContext;
import org.nuxeo.ecm.core.blob.BlobWriteContext;
import org.nuxeo.ecm.core.blob.ByteRange;
import org.nuxeo.ecm.core.blob.KeyStrategy;

public abstract class AbstractBlobStore
implements BlobStore {
    public static final char BYTE_RANGE_SEP = ';';
    private static final Logger log = LogManager.getLogger(AbstractBlobStore.class);
    protected final String name;
    protected final KeyStrategy keyStrategy;

    public AbstractBlobStore(String name, KeyStrategy keyStrategy) {
        this.name = name;
        this.keyStrategy = keyStrategy;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void logTrace(String arrow, String message) {
        this.logTrace(null, arrow, null, message);
    }

    protected void logTrace(String source, String arrow, String dest, String message) {
        if (source == null) {
            source = "Nuxeo";
        }
        if (dest == null) {
            dest = this.name;
        }
        this.logTrace(source + " " + arrow + " " + dest + ": " + message);
    }

    protected void logTrace(String message) {
        log.trace(message);
    }

    @Override
    public boolean hasVersioning() {
        return false;
    }

    @Override
    public KeyStrategy getKeyStrategy() {
        return this.keyStrategy;
    }

    @Override
    public BlobStore unwrap() {
        return this;
    }

    @Override
    public String writeBlob(BlobContext blobContext) throws IOException {
        BlobWriteContext blobWriteContext = this.keyStrategy.getBlobWriteContext(blobContext);
        return this.writeBlob(blobWriteContext);
    }

    @Override
    public void writeBlobProperties(BlobUpdateContext blobUpdateContext) throws IOException {
    }

    @Override
    public void deleteBlob(BlobContext blobContext) {
        BlobWriteContext blobWriteContext = this.keyStrategy.getBlobWriteContext(blobContext);
        String key = blobWriteContext.getKey();
        if (key == null) {
            throw new NuxeoException("Cannot delete blob with " + this.getClass().getName());
        }
        this.deleteBlob(key);
    }

    @Override
    public boolean copyBlobIsOptimized(BlobStore sourceStore) {
        BlobStore unwrapped = this.unwrap();
        if (unwrapped == this) {
            throw new UnsupportedOperationException("Class " + this.getClass().getName() + " must implement copyBlobIsOptimized");
        }
        return unwrapped.copyBlobIsOptimized(sourceStore.unwrap());
    }

    protected String stripBlobKeyPrefix(String key) {
        int colon = key.indexOf(58);
        if (colon >= 0) {
            key = key.substring(colon + 1);
        }
        return key;
    }

    public static String setByteRangeInKey(String key, ByteRange byteRange) {
        return key + String.valueOf(';') + byteRange.getStart() + String.valueOf(';') + byteRange.getEnd();
    }

    public static ByteRange getByteRangeFromKey(MutableObject<String> keyHolder) {
        String key = (String)keyHolder.getValue();
        int j = key.lastIndexOf(59);
        int i = key.lastIndexOf(59, j - 1);
        if (j > 0) {
            try {
                long start = Long.parseLong(key.substring(i + 1, j));
                long end = Long.parseLong(key.substring(j + 1));
                keyHolder.setValue((Object)key.substring(0, i));
                return ByteRange.inclusive(start, end);
            }
            catch (NumberFormatException e) {
                log.debug("Cannot parse byte range in key: {}", (Object)key, (Object)e);
            }
        }
        return null;
    }

    protected String randomString() {
        return String.valueOf(this.randomLong());
    }

    protected long randomLong() {
        long value;
        while ((value = ThreadLocalRandom.current().nextLong()) == Long.MIN_VALUE) {
        }
        if (value < 0L) {
            value = -value;
        }
        return value;
    }

    public void transfer(BlobWriteContext blobWriteContext, Path dest) throws IOException {
        try (OutputStream out = Files.newOutputStream(dest, new OpenOption[0]);){
            this.transfer(blobWriteContext, out);
        }
    }

    public void transfer(BlobWriteContext blobWriteContext, OutputStream out) throws IOException {
        try (InputStream in = blobWriteContext.getStream();){
            this.transfer(in, out, blobWriteContext.writeObserver);
        }
    }

    public void transfer(InputStream in, OutputStream out, KeyStrategy.WriteObserver writeObserver) throws IOException {
        if (writeObserver != null) {
            out = writeObserver.wrap(out);
        }
        IOUtils.copy((InputStream)in, (OutputStream)out);
        if (writeObserver != null) {
            writeObserver.done();
        }
    }
}

