/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.blob.BlobStore;
import org.nuxeo.ecm.core.blob.BlobStoreBlobProvider;
import org.nuxeo.ecm.core.blob.KeyStrategy;
import org.nuxeo.ecm.core.blob.LocalBlobStore;
import org.nuxeo.ecm.core.blob.LocalBlobStoreConfiguration;
import org.nuxeo.ecm.core.blob.PathStrategy;
import org.nuxeo.ecm.core.blob.PathStrategyFlat;
import org.nuxeo.ecm.core.blob.PathStrategySubDirs;
import org.nuxeo.ecm.core.blob.TransactionalBlobStore;

public class LocalBlobProvider
extends BlobStoreBlobProvider {
    private static final Logger log = LogManager.getLogger(LocalBlobProvider.class);
    protected LocalBlobStoreConfiguration config;

    @Override
    protected BlobStore getBlobStore(String blobProviderId, Map<String, String> properties) throws IOException {
        this.config = new LocalBlobStoreConfiguration(properties);
        log.info("Registering blob provider '" + blobProviderId + "' using directory: " + this.config.storageDir.getParent());
        KeyStrategy keyStrategy = this.getKeyStrategy();
        PathStrategy pathStrategy = keyStrategy.useDeDuplication() ? new PathStrategySubDirs(this.config.storageDir, this.config.descriptor.depth) : new PathStrategyFlat(this.config.storageDir);
        BlobStore store = this.newBlobStore("File", keyStrategy, pathStrategy);
        if (this.isTransactional()) {
            PathStrategyFlat transientPathStrategy = new PathStrategyFlat(this.config.tmpDir);
            LocalBlobStore transientStore = new LocalBlobStore("File_tmp", keyStrategy, transientPathStrategy);
            store = new TransactionalBlobStore(store, transientStore);
        }
        return store;
    }

    protected BlobStore newBlobStore(String name, KeyStrategy keyStrategy, PathStrategy pathStrategy) {
        return new LocalBlobStore(name, keyStrategy, pathStrategy);
    }

    @Override
    public void close() {
    }

    @Override
    protected String getDigestAlgorithm() {
        return this.config.digestConfiguration.digestAlgorithm;
    }

    public Path getStorageDir() {
        return this.config.storageDir;
    }
}

