/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.runtime.api.Framework;

public interface ManagedBlob
extends Blob {
    public String getProviderId();

    public String getKey();

    @Override
    default public InputStream getStream() throws IOException {
        BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
        BlobProvider blobProvider = blobManager.getBlobProvider(this);
        if (blobProvider == null) {
            return null;
        }
        try {
            return blobProvider.getStream(this);
        }
        catch (IOException e) {
            Logger log = LogManager.getLogger(ManagedBlob.class);
            log.debug((Object)e, (Throwable)e);
            log.error("Failed to access file: {}", new Supplier[]{this::getKey});
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    @Override
    default public File getFile() {
        BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
        BlobProvider blobProvider = blobManager.getBlobProvider(this);
        if (blobProvider == null) {
            return null;
        }
        return blobProvider.getFile(this);
    }
}

