/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob.binary;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.binary.AbstractBinaryManager;
import org.nuxeo.runtime.api.Framework;

public class Binary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(Binary.class);
    protected final String digest;
    protected final String blobProviderId;
    protected transient File file;

    protected Binary(String digest, String blobProviderId) {
        this(null, digest, blobProviderId);
    }

    public Binary(File file, String digest, String blobProviderId) {
        this.file = file;
        this.digest = digest;
        this.blobProviderId = blobProviderId;
    }

    public String getDigestAlgorithm() {
        String digest = this.getDigest();
        if (digest == null) {
            return null;
        }
        return AbstractBinaryManager.DIGESTS_BY_LENGTH.get(digest.length());
    }

    public String getDigest() {
        return this.digest;
    }

    public String getBlobProviderId() {
        return this.blobProviderId;
    }

    public InputStream getStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.digest + ")";
    }

    public File getFile() {
        return this.file;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException, ClassNotFoundException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.file = this.recomputeFile();
    }

    protected File recomputeFile() {
        BlobManager bm = (BlobManager)Framework.getService(BlobManager.class);
        BlobProvider bp = bm.getBlobProvider(this.blobProviderId);
        Binary binary = bp.getBinaryManager().getBinary(this.digest);
        if (binary == null) {
            log.warn("Cannot fetch binary with digest " + this.digest);
            return null;
        }
        return binary.file;
    }
}

