/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.thumbnail.converter;

import java.io.Serializable;
import java.util.Map;
import java.util.regex.Pattern;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.runtime.api.Framework;

public class AnyToThumbnailConverter
implements Converter {
    public static final String PDF_MIME_TYPE = "application/pdf";
    public static final Pattern PDF_MIME_TYPE_PATTERN = Pattern.compile("application/.*pdf");
    public static final String ANY_TO_PDF_CONVERTER_NAME = "any2pdf";

    public void init(ConverterDescriptor descriptor) {
    }

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) {
        Blob sourceBlob = blobHolder.getBlob();
        if (sourceBlob == null) {
            return null;
        }
        String mimeType = sourceBlob.getMimeType();
        if (mimeType == null) {
            return null;
        }
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        String converterName = null;
        if ((mimeType.startsWith("image/") || PDF_MIME_TYPE_PATTERN.matcher(mimeType).matches()) && conversionService.isConverterAvailable("pdfAndImageToThumbnail", true).isAvailable()) {
            converterName = "pdfAndImageToThumbnail";
        } else if (conversionService.isSourceMimeTypeSupported(ANY_TO_PDF_CONVERTER_NAME, mimeType) && conversionService.isConverterAvailable(ANY_TO_PDF_CONVERTER_NAME, true).isAvailable()) {
            converterName = "anyToPdfToThumbnail";
        }
        return converterName == null ? null : conversionService.convert(converterName, blobHolder, parameters);
    }
}

