/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.StreamChunk;
import org.jaudiotagger.audio.asf.util.Utils;

public final class AudioStreamChunk
extends StreamChunk {
    public static final String[][] CODEC_DESCRIPTIONS = new String[][]{{"161", " (Windows Media Audio (ver 7,8,9))"}, {"162", " (Windows Media Audio 9 series (Professional))"}, {"163", "(Windows Media Audio 9 series (Lossless))"}, {"7A21", " (GSM-AMR (CBR))"}, {"7A22", " (GSM-AMR (VBR))"}};
    public static final long WMA = 353L;
    public static final long WMA_CBR = 31265L;
    public static final long WMA_LOSSLESS = 355L;
    public static final long WMA_PRO = 354L;
    public static final long WMA_VBR = 31266L;
    private long averageBytesPerSec;
    private int bitsPerSample;
    private long blockAlignment;
    private long channelCount;
    private byte[] codecData = new byte[0];
    private long compressionFormat;
    private GUID errorConcealment;
    private long samplingRate;

    public AudioStreamChunk(BigInteger chunkLen) {
        super(GUID.GUID_AUDIOSTREAM, chunkLen);
    }

    public long getAverageBytesPerSec() {
        return this.averageBytesPerSec;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public long getBlockAlignment() {
        return this.blockAlignment;
    }

    public long getChannelCount() {
        return this.channelCount;
    }

    public byte[] getCodecData() {
        return (byte[])this.codecData.clone();
    }

    public String getCodecDescription() {
        StringBuilder result = new StringBuilder(Long.toHexString(this.getCompressionFormat()));
        String furtherDesc = " (Unknown)";
        for (String[] aCODEC_DESCRIPTIONS : CODEC_DESCRIPTIONS) {
            if (!aCODEC_DESCRIPTIONS[0].equalsIgnoreCase(result.toString())) continue;
            furtherDesc = aCODEC_DESCRIPTIONS[1];
            break;
        }
        if (result.length() % 2 == 0) {
            result.insert(0, "0x");
        } else {
            result.insert(0, "0x0");
        }
        result.append(furtherDesc);
        return result.toString();
    }

    public long getCompressionFormat() {
        return this.compressionFormat;
    }

    public GUID getErrorConcealment() {
        return this.errorConcealment;
    }

    public int getKbps() {
        return (int)this.getAverageBytesPerSec() * 8 / 1000;
    }

    public long getSamplingRate() {
        return this.samplingRate;
    }

    public boolean isErrorConcealed() {
        return this.getErrorConcealment().equals(GUID.GUID_AUDIO_ERROR_CONCEALEMENT_INTERLEAVED);
    }

    public String prettyPrint(String prefix) {
        StringBuilder result = new StringBuilder(super.prettyPrint(prefix));
        result.append(prefix).append("  |-> Audio info:").append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("  |  : Bitrate : ").append(this.getKbps()).append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("  |  : Channels : ").append(this.getChannelCount()).append(" at ").append(this.getSamplingRate()).append(" Hz").append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("  |  : Bits per Sample: ").append(this.getBitsPerSample()).append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("  |  : Formatcode: ").append(this.getCodecDescription()).append(Utils.LINE_SEPARATOR);
        return result.toString();
    }

    public void setAverageBytesPerSec(long avgeBytesPerSec) {
        this.averageBytesPerSec = avgeBytesPerSec;
    }

    public void setBitsPerSample(int bps) {
        this.bitsPerSample = bps;
    }

    public void setBlockAlignment(long align) {
        this.blockAlignment = align;
    }

    public void setChannelCount(long channels) {
        this.channelCount = channels;
    }

    public void setCodecData(byte[] codecSpecificData) {
        if (codecSpecificData == null) {
            throw new IllegalArgumentException();
        }
        this.codecData = (byte[])codecSpecificData.clone();
    }

    public void setCompressionFormat(long cFormatCode) {
        this.compressionFormat = cFormatCode;
    }

    public void setErrorConcealment(GUID errConc) {
        this.errorConcealment = errConc;
    }

    public void setSamplingRate(long sampRate) {
        this.samplingRate = sampRate;
    }
}

