/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4.atom;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.HashMap;
import java.util.Map;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.mp4.Mp4NotMetaFieldKey;
import org.jaudiotagger.audio.mp4.atom.AbstractMp4Box;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;

public class Mp4HdlrBox
extends AbstractMp4Box {
    public static final int VERSION_FLAG_LENGTH = 1;
    public static final int OTHER_FLAG_LENGTH = 3;
    public static final int RESERVED_FLAG_LENGTH = 4;
    public static final int HANDLER_LENGTH = 4;
    public static final int RESERVED1_LENGTH = 4;
    public static final int RESERVED2_LENGTH = 4;
    public static final int RESERVED3_LENGTH = 4;
    public static final int NAME_LENGTH = 2;
    public static final int HANDLER_POS = 8;
    public static final int RESERVED1_POS = 12;
    public static final int ITUNES_META_HDLR_DAT_LENGTH = 26;
    private int reserved;
    private String handlerType;
    private String name;
    private MediaDataType mediaDataType;
    private static Map<String, MediaDataType> mediaDataTypeMap = new HashMap<String, MediaDataType>();

    public Mp4HdlrBox(Mp4BoxHeader header, ByteBuffer dataBuffer) {
        this.header = header;
        this.dataBuffer = dataBuffer;
    }

    public void processData() throws CannotReadException {
        this.dataBuffer.position(this.dataBuffer.position() + 1 + 3 + 4);
        CharsetDecoder decoder = Charset.forName("ISO-8859-1").newDecoder();
        try {
            this.handlerType = decoder.decode((ByteBuffer)this.dataBuffer.slice().limit(4)).toString();
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        this.mediaDataType = mediaDataTypeMap.get(this.handlerType);
    }

    public String getHandlerType() {
        return this.handlerType;
    }

    public MediaDataType getMediaDataType() {
        return this.mediaDataType;
    }

    public String toString() {
        String s = "handlerType:" + this.handlerType + ":human readable:" + this.mediaDataType.getDescription();
        return s;
    }

    public static Mp4HdlrBox createiTunesStyleHdlrBox() {
        Mp4BoxHeader hdlrHeader = new Mp4BoxHeader(Mp4NotMetaFieldKey.HDLR.getFieldName());
        hdlrHeader.setLength(34);
        ByteBuffer hdlrData = ByteBuffer.allocate(26);
        hdlrData.put(8, (byte)109);
        hdlrData.put(9, (byte)100);
        hdlrData.put(10, (byte)105);
        hdlrData.put(11, (byte)114);
        hdlrData.put(12, (byte)97);
        hdlrData.put(13, (byte)112);
        hdlrData.put(14, (byte)112);
        hdlrData.put(15, (byte)108);
        hdlrData.rewind();
        Mp4HdlrBox hdlrBox = new Mp4HdlrBox(hdlrHeader, hdlrData);
        return hdlrBox;
    }

    static {
        for (MediaDataType next : MediaDataType.values()) {
            mediaDataTypeMap.put(next.getId(), next);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MediaDataType {
        ODSM("odsm", "ObjectDescriptorStream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO"),
        CRSM("crsm", "ClockReferenceStream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO"),
        SDSM("sdsm", "SceneDescriptionStream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO"),
        M7SM("m7sm", "MPEG7Stream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO"),
        OCSM("ocsm", "ObjectContentInfoStream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO"),
        IPSM("ipsm", "IPMP Stream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO"),
        MJSM("mjsm", "MPEG-J Stream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO"),
        MDIR("mdir", "Apple Meta Data iTunes Reader"),
        MP7B("mp7b", "MPEG-7 binary XML"),
        MP7T("mp7t", "MPEG-7 XML"),
        VIDE("vide", "Video Track"),
        SOUN("soun", "Sound Track"),
        HINT("hint", "Hint Track"),
        APPL("appl", "Apple specific"),
        META("meta", "Timed Metadata track - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO");

        private String id;
        private String description;

        private MediaDataType(String id, String description) {
            this.id = id;
            this.description = description;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

