/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.codec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import zipkin2.Span;
import zipkin2.codec.BytesDecoder;
import zipkin2.codec.Encoding;
import zipkin2.internal.JsonCodec;
import zipkin2.internal.Nullable;
import zipkin2.internal.Proto3Codec;
import zipkin2.internal.ThriftCodec;
import zipkin2.internal.V1JsonSpanReader;
import zipkin2.internal.V2SpanReader;
import zipkin2.v1.V1Span;
import zipkin2.v1.V1SpanConverter;

public enum SpanBytesDecoder implements BytesDecoder<Span>
{
    JSON_V1{

        @Override
        public Encoding encoding() {
            return Encoding.JSON;
        }

        @Override
        public boolean decode(byte[] bytes, Collection<Span> out) {
            Span result = this.decodeOne(bytes);
            if (result == null) {
                return false;
            }
            out.add(result);
            return true;
        }

        @Override
        public boolean decodeList(byte[] spans, Collection<Span> out) {
            return new V1JsonSpanReader().readList(spans, out);
        }

        @Override
        public Span decodeOne(byte[] span) {
            V1Span v1 = JsonCodec.readOne(new V1JsonSpanReader(), span);
            ArrayList<Span> out = new ArrayList<Span>(1);
            V1SpanConverter.create().convert(v1, out);
            return (Span)out.get(0);
        }

        @Override
        public List<Span> decodeList(byte[] spans) {
            return 1.decodeList(this, spans);
        }
    }
    ,
    THRIFT{

        @Override
        public Encoding encoding() {
            return Encoding.THRIFT;
        }

        @Override
        public boolean decode(byte[] span, Collection<Span> out) {
            return ThriftCodec.read(span, out);
        }

        @Override
        public boolean decodeList(byte[] spans, Collection<Span> out) {
            return ThriftCodec.readList(spans, out);
        }

        @Override
        public Span decodeOne(byte[] span) {
            return ThriftCodec.readOne(span);
        }

        @Override
        public List<Span> decodeList(byte[] spans) {
            return 2.decodeList(this, spans);
        }
    }
    ,
    JSON_V2{

        @Override
        public Encoding encoding() {
            return Encoding.JSON;
        }

        @Override
        public boolean decode(byte[] span, Collection<Span> out) {
            return JsonCodec.read(new V2SpanReader(), span, out);
        }

        @Override
        public boolean decodeList(byte[] spans, Collection<Span> out) {
            return JsonCodec.readList(new V2SpanReader(), spans, out);
        }

        @Override
        @Nullable
        public Span decodeOne(byte[] span) {
            return JsonCodec.readOne(new V2SpanReader(), span);
        }

        @Override
        public List<Span> decodeList(byte[] spans) {
            return 3.decodeList(this, spans);
        }
    }
    ,
    PROTO3{

        @Override
        public Encoding encoding() {
            return Encoding.PROTO3;
        }

        @Override
        public boolean decode(byte[] span, Collection<Span> out) {
            return Proto3Codec.read(span, out);
        }

        @Override
        public boolean decodeList(byte[] spans, Collection<Span> out) {
            return Proto3Codec.readList(spans, out);
        }

        @Override
        @Nullable
        public Span decodeOne(byte[] span) {
            return Proto3Codec.readOne(span);
        }

        @Override
        public List<Span> decodeList(byte[] spans) {
            return 4.decodeList(this, spans);
        }
    };


    static List<Span> decodeList(SpanBytesDecoder decoder, byte[] spans) {
        ArrayList<Span> out = new ArrayList<Span>();
        if (!decoder.decodeList(spans, out)) {
            return Collections.emptyList();
        }
        return out;
    }
}

