/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.Map;
import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.Source;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;

public class Html2TextConverter
implements Converter {
    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        try {
            Source source;
            Blob blob = blobHolder.getBlob();
            if (blob instanceof StringBlob) {
                source = new Source((CharSequence)blob.getString());
            } else if (blob.getEncoding() != null) {
                InputStreamReader reader = new InputStreamReader(blob.getStream(), blob.getEncoding());
                source = new Source((Reader)reader);
            } else {
                source = new Source(blob.getStream());
            }
            Renderer renderer = source.getRenderer();
            renderer.setIncludeHyperlinkURLs(false);
            renderer.setDecorateFontStyles(false);
            String text = renderer.toString();
            text = text.replaceAll("\r\n", "\n");
            text = text.replaceAll(" *\n", "\n");
            text = text.replaceAll("\\n\\n+", "\n\n");
            text = text.trim();
            return new SimpleCachableBlobHolder(Blobs.createBlob((String)text));
        }
        catch (IOException e) {
            throw new ConversionException("Error during Html2Text conversion", blobHolder, (Throwable)e);
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

