/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.listener;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class PictureViewsGenerationListener
implements EventListener {
    public static final String DISABLE_PICTURE_VIEWS_GENERATION_LISTENER = "disablePictureViewsGenerationListener";

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        Boolean block = (Boolean)event.getContext().getProperty(DISABLE_PICTURE_VIEWS_GENERATION_LISTENER);
        if (Boolean.TRUE.equals(block)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc.hasFacet("Picture") && !doc.isProxy()) {
            String query = "SELECT * FROM Document WHERE ecm:uuid='" + doc.getId() + "'";
            BulkService service = (BulkService)Framework.getService(BulkService.class);
            String username = ctx.getPrincipal().getName();
            service.submit(new BulkCommand.Builder("recomputeViews", query, username).param("xpath", (Serializable)((Object)"file:content")).build());
        }
    }
}

