/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.content.template.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.repository.RepositoryInitializationHandler;
import org.nuxeo.ecm.platform.content.template.listener.RepositoryInitializationListener;
import org.nuxeo.ecm.platform.content.template.service.ContentFactory;
import org.nuxeo.ecm.platform.content.template.service.ContentFactoryDescriptor;
import org.nuxeo.ecm.platform.content.template.service.ContentTemplateService;
import org.nuxeo.ecm.platform.content.template.service.FactoryBindingDescriptor;
import org.nuxeo.ecm.platform.content.template.service.FactoryBindingRegistry;
import org.nuxeo.ecm.platform.content.template.service.PostContentCreationHandler;
import org.nuxeo.ecm.platform.content.template.service.PostContentCreationHandlerDescriptor;
import org.nuxeo.ecm.platform.content.template.service.PostContentCreationHandlerRegistry;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ContentTemplateServiceImpl
extends DefaultComponent
implements ContentTemplateService {
    public static final String NAME = "org.nuxeo.ecm.platform.content.template.service.TemplateService";
    public static final String FACTORY_DECLARATION_EP = "factory";
    public static final String FACTORY_BINDING_EP = "factoryBinding";
    public static final String POST_CONTENT_CREATION_HANDLERS_EP = "postContentCreationHandlers";
    private static final Log log = LogFactory.getLog(ContentTemplateServiceImpl.class);
    private final Map<String, ContentFactoryDescriptor> factories = new HashMap<String, ContentFactoryDescriptor>();
    private FactoryBindingRegistry factoryBindings;
    private PostContentCreationHandlerRegistry postContentCreationHandlers;
    private RepositoryInitializationHandler initializationHandler;

    public void activate(ComponentContext context) {
        this.initializationHandler = new RepositoryInitializationListener();
        this.initializationHandler.install();
        this.factoryBindings = new FactoryBindingRegistry();
        this.postContentCreationHandlers = new PostContentCreationHandlerRegistry();
    }

    public void deactivate(ComponentContext context) {
        if (this.initializationHandler != null) {
            this.initializationHandler.uninstall();
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(FACTORY_DECLARATION_EP)) {
            ContentFactoryDescriptor descriptor = (ContentFactoryDescriptor)contribution;
            this.factories.put(descriptor.getName(), descriptor);
        } else if (extensionPoint.equals(FACTORY_BINDING_EP)) {
            FactoryBindingDescriptor descriptor = (FactoryBindingDescriptor)contribution;
            if (this.factories.containsKey(descriptor.getFactoryName())) {
                this.factoryBindings.addContribution(descriptor);
            } else {
                log.error((Object)("Factory Binding" + descriptor.getName() + " can not be registered since Factory " + descriptor.getFactoryName() + " is not registered"));
            }
        } else if (POST_CONTENT_CREATION_HANDLERS_EP.equals(extensionPoint)) {
            PostContentCreationHandlerDescriptor descriptor = (PostContentCreationHandlerDescriptor)contribution;
            this.postContentCreationHandlers.addContribution(descriptor);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(FACTORY_DECLARATION_EP)) {
            ContentFactoryDescriptor descriptor = (ContentFactoryDescriptor)contribution;
            this.factories.remove(descriptor.getName());
        } else if (extensionPoint.equals(FACTORY_BINDING_EP)) {
            FactoryBindingDescriptor descriptor = (FactoryBindingDescriptor)contribution;
            this.factoryBindings.removeContribution(descriptor);
        } else if (POST_CONTENT_CREATION_HANDLERS_EP.equals(extensionPoint)) {
            PostContentCreationHandlerDescriptor descriptor = (PostContentCreationHandlerDescriptor)contribution;
            this.postContentCreationHandlers.removeContribution(descriptor);
        }
    }

    @Override
    public ContentFactory getFactoryForType(String documentType) {
        FactoryBindingDescriptor descriptor = this.factoryBindings.getContribution(documentType);
        if (descriptor == null || !documentType.equals(descriptor.getTargetType())) {
            return null;
        }
        return this.getFactoryInstance(descriptor);
    }

    public ContentFactory getFactoryForFacet(String facet) {
        FactoryBindingDescriptor descriptor = this.factoryBindings.getContribution(facet);
        if (descriptor == null || !facet.equals(descriptor.getTargetFacet())) {
            return null;
        }
        return this.getFactoryInstance(descriptor);
    }

    protected ContentFactory getFactoryInstance(FactoryBindingDescriptor descriptor) {
        ContentFactoryDescriptor factoryDescriptor = this.factories.get(descriptor.getFactoryName());
        try {
            ContentFactory factory = factoryDescriptor.getClassName().getConstructor(new Class[0]).newInstance(new Object[0]);
            boolean factoryOK = factory.initFactory(descriptor.getOptions(), descriptor.getRootAcl(), descriptor.getTemplate());
            if (!factoryOK) {
                log.error((Object)("Error while initializing instance of factory " + factoryDescriptor.getName()));
                return null;
            }
            return factory;
        }
        catch (ReflectiveOperationException e) {
            log.error((Object)("Error while creating instance of factory " + factoryDescriptor.getName() + " :" + e.getMessage()));
            return null;
        }
    }

    @Override
    public void executeFactoryForType(DocumentModel createdDocument) {
        ContentFactory factory = this.getFactoryForType(createdDocument.getType());
        if (factory != null) {
            factory.createContentStructure(createdDocument);
        }
        Set facets = createdDocument.getFacets();
        for (String facet : facets) {
            factory = this.getFactoryForFacet(facet);
            if (factory == null) continue;
            factory.createContentStructure(createdDocument);
        }
    }

    @Override
    public void executePostContentCreationHandlers(CoreSession session) {
        for (PostContentCreationHandler handler : this.postContentCreationHandlers.getOrderedHandlers()) {
            handler.execute(session);
        }
    }

    public Map<String, ContentFactoryDescriptor> getFactories() {
        return this.factories;
    }

    public Map<String, FactoryBindingDescriptor> getFactoryBindings() {
        return this.factoryBindings.toMap();
    }
}

