/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.content.template.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.content.template.service.ACEDescriptor;
import org.nuxeo.ecm.platform.content.template.service.NotificationDescriptor;
import org.nuxeo.ecm.platform.content.template.service.PropertyDescriptor;

@XObject(value="templateItem")
public class TemplateItemDescriptor
implements Serializable {
    private static final long serialVersionUID = 18765764747899L;
    @XNode(value="@typeName")
    private String typeName;
    @XNode(value="@id")
    private String id;
    @XNode(value="@title")
    private String title;
    @XNode(value="@path")
    private String path;
    @XNode(value="@description")
    private String description;
    @XNodeList(value="acl/ace", type=ArrayList.class, componentType=ACEDescriptor.class)
    public List<ACEDescriptor> acl;
    @XNodeList(value="properties/property", type=ArrayList.class, componentType=PropertyDescriptor.class)
    public List<PropertyDescriptor> properties;
    @XNodeList(value="notifications/notification", type=ArrayList.class, componentType=NotificationDescriptor.class)
    public List<NotificationDescriptor> notifications;

    public TemplateItemDescriptor() {
        this.acl = new ArrayList<ACEDescriptor>();
        this.properties = new ArrayList<PropertyDescriptor>();
        this.notifications = new ArrayList<NotificationDescriptor>();
    }

    public TemplateItemDescriptor(TemplateItemDescriptor toCopy) {
        this.typeName = toCopy.typeName;
        this.id = toCopy.id;
        this.title = toCopy.title;
        this.path = toCopy.path;
        this.description = toCopy.description;
        this.acl = toCopy.acl.stream().map(ACEDescriptor::new).collect(Collectors.toList());
        this.properties = toCopy.properties.stream().map(PropertyDescriptor::new).collect(Collectors.toList());
        this.notifications = toCopy.notifications.stream().map(NotificationDescriptor::new).collect(Collectors.toList());
    }

    public String getPath() {
        return this.path;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTitle() {
        return this.title;
    }

    public List<ACEDescriptor> getAcl() {
        return this.acl;
    }

    public List<PropertyDescriptor> getProperties() {
        return this.properties;
    }

    public List<NotificationDescriptor> getNotifications() {
        return this.notifications;
    }
}

