/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="Document.RestoreVersion", category="Document", label="Restore Version", description="Restores a document to the input version document. If createVersion is true, a version of the live document will be created before restoring it to the input version. If checkout is true, a checkout will be processed after restoring the document, visible in the UI by the '+' symbol beside the version number. Returns the restored document.")
public class RestoreVersion {
    public static final String ID = "Document.RestoreVersion";
    @Context
    protected CoreSession session;
    @Param(name="createVersion", required=false, values={"false"})
    protected boolean createVersion = false;
    @Param(name="checkout", required=false, values={"false"})
    protected boolean checkout = false;

    @OperationMethod
    public DocumentModel run(DocumentModel version) {
        DocumentModel liveDoc = this.session.getSourceDocument(version.getRef());
        return this.session.restoreToVersion(liveDoc.getRef(), version.getRef(), !this.createVersion, !this.checkout);
    }
}

