/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuxeo.ecm.core.api.NuxeoException;

public enum APIVersion {
    V1(1),
    V11(11);

    public static final String API_VERSION_ATTRIBUTE_NAME = "APIVersion";
    public static final Comparator<APIVersion> COMPARATOR;
    public static final Map<Integer, APIVersion> VALID_VERSIONS;
    public static final APIVersion LATEST_VERSION;
    protected final int version;

    public static APIVersion of(int version) {
        APIVersion apiVersion = VALID_VERSIONS.get(version);
        if (apiVersion == null) {
            throw new NuxeoException(String.format("%s is not part of the valid versions: %s", version, VALID_VERSIONS.keySet()), 400);
        }
        return apiVersion;
    }

    public static APIVersion latest() {
        return LATEST_VERSION;
    }

    private APIVersion(int version) {
        this.version = version;
    }

    public int toInt() {
        return this.version;
    }

    public boolean eq(@NotNull APIVersion other) {
        return this.version == other.version;
    }

    public boolean neq(@NotNull APIVersion other) {
        return this.version != other.version;
    }

    public boolean lt(@NotNull APIVersion other) {
        return this.version < other.version;
    }

    public boolean lte(@NotNull APIVersion other) {
        return this.version <= other.version;
    }

    public boolean gt(@NotNull APIVersion other) {
        return this.version > other.version;
    }

    public boolean gte(@NotNull APIVersion other) {
        return this.version >= other.version;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this));
    }

    static {
        COMPARATOR = Comparator.comparingInt(v -> v.version);
        VALID_VERSIONS = Stream.of(APIVersion.values()).sorted(COMPARATOR).collect(Collectors.toMap(v -> v.version, Function.identity(), (v, w) -> v, LinkedHashMap::new));
        LATEST_VERSION = Stream.of(APIVersion.values()).max(COMPARATOR).orElseThrow(() -> new NuxeoException("No REST API version found"));
    }
}

