/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.registry.context;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.APIVersion;
import org.nuxeo.ecm.core.io.registry.MarshallingException;
import org.nuxeo.ecm.core.io.registry.context.DepthValues;
import org.nuxeo.ecm.core.io.registry.context.RenderingContextImpl;
import org.nuxeo.ecm.core.io.registry.context.WrappedContext;

public interface RenderingContext {
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    public static final String DEFAULT_URL = "http://fake-url.nuxeo.com/";
    public static final String RESPONSE_HEADER_ENTITY_TYPE_KEY = "ENTITY_TYPE";
    public static final String REPOSITORY_NAME_REQUEST_HEADER = "X-NXRepository";
    public static final String REPOSITORY_NAME_REQUEST_PARAMETER = "nxrepository";

    public Locale getLocale();

    public String getBaseUrl();

    public SessionWrapper getSession(DocumentModel var1) throws MarshallingException;

    public void setExistingSession(CoreSession var1);

    public Set<String> getProperties();

    public Set<String> getFetched(String var1);

    public Set<String> getTranslated(String var1);

    public Set<String> getEnrichers(String var1);

    public WrappedContext wrap();

    public <T> T getParameter(String var1);

    public boolean getBooleanParameter(String var1);

    public <T> List<T> getParameters(String var1);

    public Map<String, List<Object>> getAllParameters();

    public void setParameterValues(String var1, Object ... var2);

    public void setParameterListValues(String var1, List<Object> var2);

    public void addParameterValues(String var1, Object ... var2);

    public void addParameterListValues(String var1, List<?> var2);

    public APIVersion getAPIVersion();

    public static class SessionWrapper
    implements Closeable {
        private CoreSession session;

        public SessionWrapper(CoreSession session) {
            this.session = session;
        }

        public CoreSession getSession() {
            return this.session;
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static final class CtxBuilder {
        private CtxBuilder() {
        }

        public static RenderingContextImpl.RenderingContextBuilder builder() {
            return new RenderingContextImpl.RenderingContextBuilder();
        }

        public static RenderingContextImpl.RenderingContextBuilder base(String url) {
            RenderingContextImpl.RenderingContextBuilder builder = new RenderingContextImpl.RenderingContextBuilder();
            return builder.base(url);
        }

        public static RenderingContextImpl.RenderingContextBuilder locale(Locale locale) {
            RenderingContextImpl.RenderingContextBuilder builder = new RenderingContextImpl.RenderingContextBuilder();
            return builder.locale(locale);
        }

        public static RenderingContextImpl.RenderingContextBuilder session(CoreSession session) {
            RenderingContextImpl.RenderingContextBuilder builder = new RenderingContextImpl.RenderingContextBuilder();
            return builder.session(session);
        }

        public static RenderingContextImpl.RenderingContextBuilder param(String name, Object value) {
            RenderingContextImpl.RenderingContextBuilder builder = new RenderingContextImpl.RenderingContextBuilder();
            return builder.param(name, value);
        }

        public static RenderingContextImpl.RenderingContextBuilder paramValues(String name, Object ... values) {
            RenderingContextImpl.RenderingContextBuilder builder = new RenderingContextImpl.RenderingContextBuilder();
            return builder.paramValues(name, values);
        }

        public static RenderingContextImpl.RenderingContextBuilder paramList(String name, List<?> values) {
            RenderingContextImpl.RenderingContextBuilder builder = new RenderingContextImpl.RenderingContextBuilder();
            return builder.paramList(name, values);
        }

        public static RenderingContextImpl.RenderingContextBuilder properties(String ... schemaName) {
            RenderingContextImpl.RenderingContextBuilder builder = new RenderingContextImpl.RenderingContextBuilder();
            return builder.properties(schemaName);
        }

        public static RenderingContextImpl.RenderingContextBuilder fetch(String entityType, String ... propertyName) {
            RenderingContextImpl.RenderingContextBuilder builder = new RenderingContextImpl.RenderingContextBuilder();
            return builder.fetch(entityType, propertyName);
        }

        public static RenderingContextImpl.RenderingContextBuilder fetchInDoc(String ... propertyName) {
            RenderingContextImpl.RenderingContextBuilder builder = new RenderingContextImpl.RenderingContextBuilder();
            return builder.fetchInDoc(propertyName);
        }

        public static RenderingContextImpl.RenderingContextBuilder translate(String entityType, String ... propertyName) {
            RenderingContextImpl.RenderingContextBuilder builder = new RenderingContextImpl.RenderingContextBuilder();
            return builder.translate(entityType, propertyName);
        }

        public static RenderingContextImpl.RenderingContextBuilder enrich(String entityType, String ... enricherName) {
            RenderingContextImpl.RenderingContextBuilder builder = new RenderingContextImpl.RenderingContextBuilder();
            return builder.enrich(entityType, enricherName);
        }

        public static RenderingContextImpl.RenderingContextBuilder enrichDoc(String ... enricherName) {
            RenderingContextImpl.RenderingContextBuilder builder = new RenderingContextImpl.RenderingContextBuilder();
            return builder.enrichDoc(enricherName);
        }

        public static RenderingContextImpl.RenderingContextBuilder depth(DepthValues value) {
            RenderingContextImpl.RenderingContextBuilder builder = new RenderingContextImpl.RenderingContextBuilder();
            return builder.depth(value);
        }

        public static RenderingContext get() {
            RenderingContextImpl.RenderingContextBuilder builder = new RenderingContextImpl.RenderingContextBuilder();
            return builder.get();
        }
    }
}

