/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;

public class UserPrincipal
implements NuxeoPrincipal,
Serializable {
    private static final long serialVersionUID = 2013321088068583749L;
    protected boolean anonymous;
    protected boolean administrator;
    protected String userName;
    protected List<String> groups;
    protected List<String> roles;
    protected String firstName;
    protected String lastName;
    protected String email;
    protected String company;
    protected transient String password;
    protected DocumentModel model;
    protected String originatingUser;

    public UserPrincipal(String username, List<String> groups, boolean anonymous, boolean administrator) {
        this.userName = username;
        this.groups = Objects.requireNonNullElseGet(groups, Collections::emptyList);
        this.anonymous = anonymous;
        this.administrator = administrator;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String getCompany() {
        return this.company;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void setCompany(String company) {
        this.company = company;
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public void setName(String name) {
        this.userName = name;
    }

    @Override
    public String getName() {
        return this.userName;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public List<String> getAllGroups() {
        return this.groups;
    }

    @Override
    public List<String> getRoles() {
        return this.roles;
    }

    @Override
    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    @Override
    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getPrincipalId() {
        return null;
    }

    @Override
    public void setPrincipalId(String principalId) {
    }

    @Override
    public DocumentModel getModel() {
        return this.model;
    }

    @Override
    public void setModel(DocumentModel model) {
        this.model = model;
    }

    @Override
    public boolean isMemberOf(String group) {
        return this.groups.contains(group);
    }

    @Override
    public boolean isAdministrator() {
        return this.administrator;
    }

    @Override
    public String getTenantId() {
        return null;
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public String getOriginatingUser() {
        return this.originatingUser;
    }

    @Override
    public void setOriginatingUser(String originatingUser) {
        this.originatingUser = originatingUser;
    }

    @Override
    public String getActingUser() {
        return this.getOriginatingUser() == null ? this.getName() : this.getOriginatingUser();
    }

    @Override
    public boolean isTransient() {
        String name = this.getName();
        return name != null && name.startsWith("transient/");
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.userName).append(this.groups).append(this.roles).append((Object)this.firstName).append((Object)this.lastName).append((Object)this.company).append((Object)this.password).toHashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserPrincipal)) {
            return false;
        }
        UserPrincipal that = (UserPrincipal)o;
        return new EqualsBuilder().append((Object)this.userName, (Object)that.userName).append(this.groups, that.groups).append(this.roles, that.roles).append((Object)this.firstName, (Object)that.firstName).append((Object)this.lastName, (Object)that.lastName).append((Object)this.company, (Object)that.company).append((Object)this.password, (Object)that.password).isEquals();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

