/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.blob.BlobProvider;

public abstract class AbstractBlobProvider
implements BlobProvider {
    public String blobProviderId;
    public Map<String, String> properties;

    @Override
    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        this.blobProviderId = blobProviderId;
        this.properties = properties;
    }

    protected boolean supportsUserUpdateDefaultTrue() {
        return !Boolean.parseBoolean(this.properties.get("preventUserUpdate"));
    }

    protected boolean supportsUserUpdateDefaultFalse() {
        return !Boolean.parseBoolean(this.properties.getOrDefault("preventUserUpdate", "true"));
    }

    @Override
    public boolean supportsUserUpdate() {
        return this.supportsUserUpdateDefaultTrue();
    }

    @Override
    public boolean isTransient() {
        return Boolean.parseBoolean(this.properties.get("transient"));
    }

    @Override
    public boolean isRecordMode() {
        return Boolean.parseBoolean(this.properties.get("record"));
    }

    @Override
    public boolean isTransactional() {
        return Boolean.parseBoolean(this.properties.get("transactional")) || this.isRecordMode();
    }

    @Override
    public boolean allowByteRange() {
        return Boolean.parseBoolean(this.properties.get("allowByteRange"));
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasCreateFromKeyPermission() {
        NuxeoPrincipal principal = NuxeoPrincipal.getCurrent();
        if (principal == null) {
            return false;
        }
        String createFromKeyUsers = this.properties.getOrDefault("createFromKey.users", "");
        String createFromKeyGroups = this.properties.getOrDefault("createFromKey.groups", "");
        if ("*".equals(createFromKeyUsers)) return true;
        if ("*".equals(createFromKeyGroups)) {
            return true;
        }
        List<String> authorizedUsers = Arrays.asList(createFromKeyUsers.split(","));
        List<String> authorizedGroups = Arrays.asList(createFromKeyGroups.split(","));
        if (principal.isAdministrator()) return true;
        if (authorizedUsers.contains(principal.getName())) return true;
        if (!authorizedGroups.stream().anyMatch(principal::isMemberOf)) return false;
        return true;
    }
}

