/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.export;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.export.AbstractLayoutJsonWriter;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class WidgetDefinitionJsonWriter
extends AbstractLayoutJsonWriter<WidgetDefinition> {
    public void write(WidgetDefinition entity, JsonGenerator jg) throws IOException {
        List aliases;
        Map renderingInfos;
        Object[] selectOptions;
        Map controls;
        Map propertiesByWidgetMode;
        Map properties;
        Object[] subWidgetReferences;
        Object[] subWidgetDefinitions;
        Object[] fieldDefinitions;
        Map helpLabels;
        Map labels;
        jg.writeStartObject();
        jg.writeStringField("name", entity.getName());
        jg.writeStringField("type", entity.getType());
        String typeCategory = entity.getTypeCategory();
        if (StringUtils.isNotBlank((CharSequence)typeCategory)) {
            jg.writeStringField("typeCategory", typeCategory);
        }
        if (MapUtils.isNotEmpty((Map)(labels = entity.getLabels()))) {
            this.writeSerializableMapField("labels", new TreeMap(labels), jg);
        }
        if (MapUtils.isNotEmpty((Map)(helpLabels = entity.getHelpLabels()))) {
            this.writeSerializableMapField("helpLabels", new TreeMap(helpLabels), jg);
        }
        jg.writeBooleanField("translated", entity.isTranslated());
        jg.writeBooleanField("handlingLabels", entity.isHandlingLabels());
        Map widgetModes = entity.getModes();
        if (MapUtils.isNotEmpty((Map)widgetModes)) {
            this.writeSerializableMapField("widgetModes", new TreeMap(widgetModes), jg);
        }
        if (ArrayUtils.isNotEmpty((Object[])(fieldDefinitions = entity.getFieldDefinitions()))) {
            jg.writeArrayFieldStart("fields");
            for (Object fieldDefinition : fieldDefinitions) {
                this.writeEntity(fieldDefinition, jg);
            }
            jg.writeEndArray();
        }
        if (ArrayUtils.isNotEmpty((Object[])(subWidgetDefinitions = entity.getSubWidgetDefinitions()))) {
            jg.writeArrayFieldStart("subWidgets");
            for (Object subWidgetDefinition : subWidgetDefinitions) {
                this.writeEntity(subWidgetDefinition, jg);
            }
            jg.writeEndArray();
        }
        if (ArrayUtils.isNotEmpty((Object[])(subWidgetReferences = entity.getSubWidgetReferences()))) {
            jg.writeArrayFieldStart("subWidgetRefs");
            for (Object subWidgetReference : subWidgetReferences) {
                this.writeEntity(subWidgetReference, jg);
            }
            jg.writeEndArray();
        }
        if (MapUtils.isNotEmpty((Map)(properties = entity.getProperties())) && properties.values().stream().anyMatch(MapUtils::isNotEmpty)) {
            this.writeSerializableMapMapField("properties", this.cleanAndSort(properties), jg);
        }
        if (MapUtils.isNotEmpty((Map)(propertiesByWidgetMode = entity.getWidgetModeProperties())) && propertiesByWidgetMode.values().stream().anyMatch(MapUtils::isNotEmpty)) {
            this.writeSerializableMapMapField("propertiesByWidgetMode", this.cleanAndSort(propertiesByWidgetMode), jg);
        }
        if (MapUtils.isNotEmpty((Map)(controls = entity.getControls())) && controls.values().stream().anyMatch(MapUtils::isNotEmpty)) {
            this.writeSerializableMapMapField("controls", this.cleanAndSort(controls), jg);
        }
        if (ArrayUtils.isNotEmpty((Object[])(selectOptions = entity.getSelectOptions()))) {
            jg.writeArrayFieldStart("selectOptions");
            for (Object selectOption : selectOptions) {
                this.writeEntity(selectOption, jg);
            }
            jg.writeEndArray();
        }
        if (MapUtils.isNotEmpty((Map)(renderingInfos = entity.getRenderingInfos())) && renderingInfos.values().stream().anyMatch(CollectionUtils::isNotEmpty)) {
            jg.writeObjectFieldStart("renderingInfos");
            for (Map.Entry entry : new TreeMap(renderingInfos).entrySet()) {
                this.writeSerializableListField((String)entry.getKey(), (Collection)entry.getValue(), jg);
            }
            jg.writeEndObject();
        }
        if (CollectionUtils.isNotEmpty((Collection)(aliases = entity.getAliases()))) {
            this.writeSerializableListField("aliases", aliases, jg);
        }
        jg.writeEndObject();
    }
}

