/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.matching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.MatchingAlgorithm;
import org.jgrapht.alg.util.ToleranceDoubleComparator;

public class GreedyWeightedMatching<V, E>
implements MatchingAlgorithm<V, E> {
    private final Graph<V, E> graph;
    private final Comparator<Double> comparator;

    public GreedyWeightedMatching(Graph<V, E> graph) {
        this(graph, 1.0E-9);
    }

    public GreedyWeightedMatching(Graph<V, E> graph, double epsilon) {
        if (graph == null) {
            throw new IllegalArgumentException("Input graph cannot be null");
        }
        this.graph = graph;
        this.comparator = new ToleranceDoubleComparator(epsilon);
    }

    @Override
    public MatchingAlgorithm.Matching<E> computeMatching() {
        ArrayList<E> allEdges = new ArrayList<E>(this.graph.edgeSet());
        Collections.sort(allEdges, (e1, e2) -> this.comparator.compare(this.graph.getEdgeWeight(e2), this.graph.getEdgeWeight(e1)));
        double matchingWeight = 0.0;
        HashSet matching = new HashSet();
        HashSet<V> matchedVertices = new HashSet<V>();
        for (Object e : allEdges) {
            V t;
            double edgeWeight = this.graph.getEdgeWeight(e);
            V s = this.graph.getEdgeSource(e);
            if (s.equals(t = this.graph.getEdgeTarget(e)) || this.comparator.compare(edgeWeight, 0.0) <= 0 || matchedVertices.contains(s) || matchedVertices.contains(t)) continue;
            matching.add(e);
            matchedVertices.add(s);
            matchedVertices.add(t);
            matchingWeight += edgeWeight;
        }
        return new MatchingAlgorithm.MatchingImpl(matching, matchingWeight);
    }
}

