/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core;

import org.nuxeo.ecm.collections.api.CollectionLocationService;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.collections.api.FavoritesManager;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class FavoritesManagerImpl
extends DefaultComponent
implements FavoritesManager {
    @Override
    public void addToFavorites(DocumentModel document, CoreSession session) {
        DocumentModel favorites = this.getFavorites(session);
        if (favorites == null) {
            throw new DocumentNotFoundException("No user favorites found");
        }
        CollectionManager collectionManager = (CollectionManager)Framework.getService(CollectionManager.class);
        collectionManager.addToCollection(favorites, document, session);
    }

    @Override
    public boolean canAddToFavorites(DocumentModel document) {
        CollectionManager collectionManager = (CollectionManager)Framework.getService(CollectionManager.class);
        return collectionManager.isCollectable(document);
    }

    @Override
    @Deprecated
    public DocumentModel getFavorites(DocumentModel context, CoreSession session) {
        return this.getFavorites(session);
    }

    @Override
    public DocumentModel getFavorites(CoreSession session) {
        return ((CollectionLocationService)Framework.getService(CollectionLocationService.class)).getUserFavorites(session);
    }

    @Override
    public boolean isFavorite(DocumentModel document, CoreSession session) {
        CollectionManager collectionManager = (CollectionManager)Framework.getService(CollectionManager.class);
        DocumentModel favorites = this.getFavorites(session);
        return favorites != null && collectionManager.isInCollection(favorites, document, session);
    }

    @Override
    public void removeFromFavorites(DocumentModel document, CoreSession session) {
        DocumentModel favorites = this.getFavorites(session);
        if (favorites == null) {
            throw new DocumentNotFoundException("No user favorites found");
        }
        CollectionManager collectionManager = (CollectionManager)Framework.getService(CollectionManager.class);
        collectionManager.removeFromCollection(favorites, document, session);
    }
}

