/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.worker;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.runtime.api.Framework;

public class RemoveFromCollectionWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RemoveFromCollectionWork.class);
    public static final String CATEGORY = "removeFromCollection";
    protected static final String TITLE = "Remove From Collection Work";
    protected List<String> collectionMemberIds;
    protected String collectionId;

    public RemoveFromCollectionWork(String repoName, String collectionId, List<String> collectionMemberIds, int offset) {
        super("removeFromCollection:" + repoName + ":" + collectionId + ":" + offset);
        this.repositoryName = repoName;
        this.collectionId = collectionId;
        this.collectionMemberIds = new ArrayList<String>(collectionMemberIds);
    }

    public String getCategory() {
        return CATEGORY;
    }

    public String getTitle() {
        return TITLE;
    }

    public boolean isIdempotent() {
        return false;
    }

    public void work() {
        this.setStatus("Removing");
        if (this.collectionMemberIds != null) {
            this.setProgress(new Work.Progress(0L, (long)this.collectionMemberIds.size()));
            if (this.session == null) {
                this.openSystemSession();
            }
            CollectionManager collectionManager = (CollectionManager)Framework.getService(CollectionManager.class);
            for (int i = 0; i < this.collectionMemberIds.size(); ++i) {
                DocumentModel collectionMember;
                IdRef collectionMemberRef;
                log.trace((Object)String.format("Worker %s, deleting from Collection %s, processing CollectionMember %s", this.getId(), this.collectionId, this.collectionMemberIds.get(i)));
                if (this.collectionMemberIds.get(i) != null && this.session.exists((DocumentRef)(collectionMemberRef = new IdRef(this.collectionMemberIds.get(i)))) && collectionManager.isCollectable(collectionMember = this.session.getDocument((DocumentRef)new IdRef(this.collectionMemberIds.get(i))))) {
                    collectionManager.doRemoveFromCollection(collectionMember, this.collectionId, this.session);
                }
                this.setProgress(new Work.Progress((long)i + 1L, (long)this.collectionMemberIds.size()));
            }
        }
        this.setStatus("Done");
    }
}

