/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Iterator;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.AuthenticationLevel;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.name.LdapDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictedByFilter
implements ACITupleFilter {
    @Override
    public Collection<ACITuple> filter(Collection<ACITuple> tuples, OperationScope scope, PartitionNexusProxy proxy, Collection<LdapDN> userGroupNames, LdapDN userName, Attributes userEntry, AuthenticationLevel authenticationLevel, LdapDN entryName, String attrId, Object attrValue, Attributes entry, Collection<MicroOperation> microOperations) throws NamingException {
        if (scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) {
            return tuples;
        }
        if (tuples.size() == 0) {
            return tuples;
        }
        Iterator<ACITuple> ii = tuples.iterator();
        while (ii.hasNext()) {
            ACITuple tuple = ii.next();
            if (!tuple.isGrant() || !this.isRemovable(tuple, attrId, attrValue, entry)) continue;
            ii.remove();
        }
        return tuples;
    }

    public boolean isRemovable(ACITuple tuple, String attrId, Object attrValue, Attributes entry) {
        for (ProtectedItem item : tuple.getProtectedItems()) {
            if (!(item instanceof ProtectedItem.RestrictedBy)) continue;
            ProtectedItem.RestrictedBy rb = (ProtectedItem.RestrictedBy)item;
            for (ProtectedItem.RestrictedByItem rbItem : rb) {
                Attribute attr;
                if (!attrId.equalsIgnoreCase(rbItem.getAttributeType()) || (attr = entry.get(rbItem.getValuesIn())) != null && attr.contains(attrValue)) continue;
                return true;
            }
        }
        return false;
    }
}

