/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.collective;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.collective.CollectiveAttributesSchemaChecker;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.enumeration.SearchResultFilter;
import org.apache.directory.server.core.enumeration.SearchResultFilteringEnumeration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.constants.SchemaConstants;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.ServerSearchResult;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.AttributeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectiveAttributeService
extends BaseInterceptor {
    public static final String EXCLUDE_ALL_COLLECTIVE_ATTRIBUTES_OID = "2.5.18.0";
    public static final String EXCLUDE_ALL_COLLECTIVE_ATTRIBUTES = "excludeAllCollectiveAttributes";
    private final SearchResultFilter SEARCH_FILTER = new SearchResultFilter(){

        public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
            LdapDN name = ((ServerSearchResult)result).getDn();
            name = LdapDN.normalize((LdapDN)name, (Map)CollectiveAttributeService.this.attrTypeRegistry.getNormalizerMapping());
            Attributes entry = result.getAttributes();
            String[] retAttrs = controls.getReturningAttributes();
            CollectiveAttributeService.this.addCollectiveAttributes(name, entry, retAttrs);
            return true;
        }
    };
    private AttributeTypeRegistry attrTypeRegistry = null;
    private PartitionNexus nexus = null;
    private CollectiveAttributesSchemaChecker collectiveAttributesSchemaChecker = null;

    @Override
    public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) throws NamingException {
        super.init(factoryCfg, cfg);
        this.nexus = factoryCfg.getPartitionNexus();
        this.attrTypeRegistry = factoryCfg.getRegistries().getAttributeTypeRegistry();
        this.collectiveAttributesSchemaChecker = new CollectiveAttributesSchemaChecker(this.nexus, this.attrTypeRegistry);
    }

    private void addCollectiveAttributes(LdapDN normName, Attributes entry, String[] retAttrs) throws NamingException {
        Attributes entryWithCAS = this.nexus.lookup(new LookupOperationContext(normName, new String[]{"collectiveAttributeSubentries"}));
        Attribute caSubentries = entryWithCAS.get("collectiveAttributeSubentries");
        if (caSubentries == null) {
            return;
        }
        Attribute collectiveExclusions = entry.get("collectiveExclusions");
        HashSet<String> exclusions = new HashSet<String>();
        if (collectiveExclusions != null) {
            if (AttributeUtils.containsValueCaseIgnore((Attribute)collectiveExclusions, (Object)EXCLUDE_ALL_COLLECTIVE_ATTRIBUTES_OID) || AttributeUtils.containsValue((Attribute)collectiveExclusions, (Object)EXCLUDE_ALL_COLLECTIVE_ATTRIBUTES, (AttributeType)this.attrTypeRegistry.lookup("2.5.18.7"))) {
                return;
            }
            exclusions = new HashSet();
            for (int ii = 0; ii < collectiveExclusions.size(); ++ii) {
                AttributeType attrType = this.attrTypeRegistry.lookup((String)collectiveExclusions.get(ii));
                exclusions.add(attrType.getOid());
            }
        }
        if (retAttrs == null) {
            retAttrs = SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY;
        }
        HashSet<String> retIdsSet = new HashSet<String>(retAttrs.length);
        for (String retAttr : retAttrs) {
            retIdsSet.add(retAttr.toLowerCase());
        }
        for (int ii = 0; ii < caSubentries.size(); ++ii) {
            String subentryDnStr = (String)caSubentries.get(ii);
            LdapDN subentryDn = new LdapDN(subentryDnStr);
            Attributes subentry = this.nexus.lookup(new LookupOperationContext(subentryDn));
            NamingEnumeration<String> attrIds = subentry.getIDs();
            while (attrIds.hasMore()) {
                String attrId = attrIds.next();
                AttributeType attrType = this.attrTypeRegistry.lookup(attrId);
                if (!attrType.isCollective() || exclusions.contains(attrType.getOid())) continue;
                Set<AttributeType> allSuperTypes = this.getAllSuperTypes(attrType);
                for (String retId : retIdsSet) {
                    AttributeType retType;
                    if (retId.equals("*") || retId.equals("+") || !allSuperTypes.contains(retType = this.attrTypeRegistry.lookup(retId))) continue;
                    retIdsSet.add(attrId);
                    break;
                }
                if (!retIdsSet.contains("*") && !retIdsSet.contains(attrId)) continue;
                Attribute subentryColAttr = subentry.get(attrId);
                Attribute entryColAttr = entry.get(attrId);
                if (entryColAttr == null) {
                    entryColAttr = new AttributeImpl(attrId);
                    entry.put(entryColAttr);
                }
                for (int jj = 0; jj < subentryColAttr.size(); ++jj) {
                    entryColAttr.add(subentryColAttr.get(jj));
                }
            }
        }
    }

    private Set<AttributeType> getAllSuperTypes(AttributeType id) throws NamingException {
        HashSet<AttributeType> allSuperTypes = new HashSet<AttributeType>();
        AttributeType superType = id;
        while (superType != null) {
            if ((superType = superType.getSuperior()) == null) continue;
            allSuperTypes.add(superType);
        }
        return allSuperTypes;
    }

    @Override
    public Attributes lookup(NextInterceptor nextInterceptor, LookupOperationContext opContext) throws NamingException {
        Attributes result = nextInterceptor.lookup(opContext);
        if (result == null) {
            return null;
        }
        if (opContext.getAttrsId() == null || opContext.getAttrsId().size() == 0) {
            this.addCollectiveAttributes(opContext.getDn(), result, SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
        } else {
            this.addCollectiveAttributes(opContext.getDn(), result, opContext.getAttrsIdArray());
        }
        return result;
    }

    @Override
    public NamingEnumeration<SearchResult> list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws NamingException {
        NamingEnumeration<SearchResult> e = nextInterceptor.list(opContext);
        Invocation invocation = InvocationStack.getInstance().peek();
        return new SearchResultFilteringEnumeration(e, new SearchControls(), invocation, this.SEARCH_FILTER, "List collective Filter");
    }

    @Override
    public NamingEnumeration<SearchResult> search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws NamingException {
        NamingEnumeration<SearchResult> e = nextInterceptor.search(opContext);
        Invocation invocation = InvocationStack.getInstance().peek();
        return new SearchResultFilteringEnumeration(e, opContext.getSearchControls(), invocation, this.SEARCH_FILTER, "Search collective Filter");
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext opContext) throws NamingException {
        this.collectiveAttributesSchemaChecker.checkAdd(opContext.getDn(), opContext.getEntry());
        super.add(next, opContext);
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws NamingException {
        this.collectiveAttributesSchemaChecker.checkModify(opContext.getDn(), opContext.getModItems());
        super.modify(next, opContext);
    }
}

