/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.sp;

import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapClassLoader
extends ClassLoader {
    private static final Logger log = LoggerFactory.getLogger(LdapClassLoader.class);
    public static String defaultSearchContextsConfig = "cn=classLoaderDefaultSearchContext,ou=configuration,ou=system";
    private ServerLdapContext RootDSE;

    public LdapClassLoader(ServerLdapContext RootDSE) throws NamingException {
        super(LdapClassLoader.class.getClassLoader());
        this.RootDSE = (ServerLdapContext)RootDSE.lookup("");
    }

    private byte[] findClassInDIT(NamingEnumeration searchContexts, String name) throws ClassNotFoundException {
        String currentSearchContextName = null;
        ServerLdapContext currentSearchContext = null;
        NamingEnumeration<SearchResult> javaClassEntries = null;
        byte[] classBytes = null;
        BranchNode filter = new BranchNode(AssertionEnum.AND);
        filter.addNode((ExprNode)new SimpleNode("fullyQualifiedJavaClassName", name, AssertionEnum.EQUALITY));
        filter.addNode((ExprNode)new SimpleNode("objectClass", "javaClass", AssertionEnum.EQUALITY));
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        try {
            while (searchContexts.hasMore()) {
                currentSearchContextName = (String)searchContexts.next();
                currentSearchContext = (ServerLdapContext)this.RootDSE.lookup(currentSearchContextName);
                javaClassEntries = currentSearchContext.search((Name)LdapDN.EMPTY_LDAPDN, (ExprNode)filter, controls);
                if (!javaClassEntries.hasMore()) continue;
                log.debug("Class " + name + " found under " + currentSearchContextName + " search context.");
                SearchResult javaClassEntry = javaClassEntries.next();
                Attribute byteCode = javaClassEntry.getAttributes().get("javaClassByteCode");
                classBytes = (byte[])byteCode.get();
                break;
            }
        }
        catch (NamingException e) {
            throw new ClassNotFoundException();
        }
        return classBytes;
    }

    public Class findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = null;
        NamingEnumeration<?> defaultSearchContexts = null;
        NamingEnumeration<?> namingContexts = null;
        ServerLdapContext defaultSearchContextsConfigContext = null;
        try {
            try {
                defaultSearchContextsConfigContext = (ServerLdapContext)this.RootDSE.lookup(defaultSearchContextsConfig);
            }
            catch (NamingException e) {
                log.debug("No configuration data found for class loader default search contexts.");
            }
            if (defaultSearchContextsConfigContext != null) {
                defaultSearchContexts = defaultSearchContextsConfigContext.getAttributes("", new String[]{"classLoaderDefaultSearchContext"}).get("classLoaderDefaultSearchContext").getAll();
                try {
                    classBytes = this.findClassInDIT(defaultSearchContexts, name);
                    log.debug("Class " + name + " found under default search contexts.");
                }
                catch (ClassNotFoundException e) {
                    log.debug("Class " + name + " could not be found under default search contexts.");
                }
            }
            if (classBytes == null) {
                namingContexts = this.RootDSE.getAttributes("", new String[]{"namingContexts"}).get("namingContexts").getAll();
                classBytes = this.findClassInDIT(namingContexts, name);
            }
        }
        catch (NamingException e) {
            String msg = "Encountered JNDI failure while searching directory for class: " + name;
            log.error(msg + e);
            throw new ClassNotFoundException(msg);
        }
        catch (ClassNotFoundException e) {
            String msg = "Class " + name + " not found in DIT.";
            log.debug(msg);
            throw new ClassNotFoundException(msg);
        }
        finally {
            if (defaultSearchContexts != null) {
                try {
                    defaultSearchContexts.close();
                }
                catch (Exception e) {}
            }
            if (namingContexts != null) {
                try {
                    namingContexts.close();
                }
                catch (Exception e) {}
            }
        }
        return this.defineClass(name, classBytes, 0, classBytes.length);
    }
}

