/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.sp;

import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.sp.StoredProcEngine;
import org.apache.directory.server.core.sp.StoredProcEngineConfig;
import org.apache.directory.server.core.sp.StoredProcUtils;
import org.apache.directory.shared.ldap.constants.SchemaConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcExecutionManager {
    private final String storedProcContainer;
    private final List<StoredProcEngineConfig> storedProcEngineConfigs;

    public StoredProcExecutionManager(String storedProcContainer, List<StoredProcEngineConfig> storedProcEngineConfigs) {
        this.storedProcContainer = storedProcContainer;
        this.storedProcEngineConfigs = storedProcEngineConfigs;
    }

    public Attributes findStoredProcUnit(LdapContext rootDSE, String fullSPName) throws NamingException {
        SearchControls controls = new SearchControls();
        controls.setReturningAttributes(SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
        controls.setSearchScope(2);
        String spUnitName = StoredProcUtils.extractStoredProcUnitName(fullSPName);
        String filter = "(storedProcUnitName=" + spUnitName + ")";
        NamingEnumeration<SearchResult> results = rootDSE.search(this.storedProcContainer, filter, controls);
        Attributes spUnitEntry = ((SearchResult)results.nextElement()).getAttributes();
        return spUnitEntry;
    }

    public StoredProcEngine getStoredProcEngineInstance(Attributes spUnitEntry) throws NamingException {
        String spLangId = (String)spUnitEntry.get("storedProcLangId").get();
        for (StoredProcEngineConfig engineConfig : this.storedProcEngineConfigs) {
            StoredProcEngine engine;
            if (!engineConfig.getStoredProcLangId().equalsIgnoreCase(spLangId)) continue;
            Class<? extends StoredProcEngine> engineType = engineConfig.getStoredProcEngineType();
            try {
                engine = engineType.newInstance();
            }
            catch (InstantiationException e) {
                NamingException ne = new NamingException();
                ne.setRootCause(e);
                throw ne;
            }
            catch (IllegalAccessException e) {
                NamingException ne = new NamingException();
                ne.setRootCause(e);
                throw ne;
            }
            engine.setSPUnitEntry(spUnitEntry);
            return engine;
        }
        throw new NamingException("Stored Procedure Language, " + spLangId + " is not supported.");
    }
}

